/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationMessagingFromRecipient;
import com.mypurecloud.sdk.v2.model.ConversationMessagingToRecipient;
import com.mypurecloud.sdk.v2.model.ConversationPublicMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Channel-specific information that describes the message and the message channel/provider.")
public class ConversationMessagingChannel
implements Serializable {
    private String id = null;
    private PlatformEnum platform = null;
    private TypeEnum type = null;
    private String messageId = null;
    private ConversationMessagingToRecipient to = null;
    private ConversationMessagingFromRecipient from = null;
    private Date time = null;
    private Date dateModified = null;
    private Date dateDeleted = null;
    private ConversationPublicMetadata publicMetadata = null;

    public ConversationMessagingChannel() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The integration ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The provider type.")
    @JsonProperty(value="platform")
    public PlatformEnum getPlatform() {
        return this.platform;
    }

    public ConversationMessagingChannel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies if this message is part of a private or public conversation.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    @ApiModelProperty(example="null", value="Unique provider ID of the message such as a Facebook message ID.")
    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    @ApiModelProperty(example="null", value="Information about the recipient the message is sent to.")
    @JsonProperty(value="to")
    public ConversationMessagingToRecipient getTo() {
        return this.to;
    }

    @ApiModelProperty(example="null", value="Information about the recipient the message is received from.")
    @JsonProperty(value="from")
    public ConversationMessagingFromRecipient getFrom() {
        return this.from;
    }

    @ApiModelProperty(example="null", value="Original time of the event. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="time")
    public Date getTime() {
        return this.time;
    }

    @ApiModelProperty(example="null", value="Time the message was edited. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="Time the message was deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateDeleted")
    public Date getDateDeleted() {
        return this.dateDeleted;
    }

    public ConversationMessagingChannel publicMetadata(ConversationPublicMetadata publicMetadata) {
        this.publicMetadata = publicMetadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Information about a public message.")
    @JsonProperty(value="publicMetadata")
    public ConversationPublicMetadata getPublicMetadata() {
        return this.publicMetadata;
    }

    public void setPublicMetadata(ConversationPublicMetadata publicMetadata) {
        this.publicMetadata = publicMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationMessagingChannel conversationMessagingChannel = (ConversationMessagingChannel)o;
        return Objects.equals(this.id, conversationMessagingChannel.id) && Objects.equals((Object)this.platform, (Object)conversationMessagingChannel.platform) && Objects.equals((Object)this.type, (Object)conversationMessagingChannel.type) && Objects.equals(this.messageId, conversationMessagingChannel.messageId) && Objects.equals(this.to, conversationMessagingChannel.to) && Objects.equals(this.from, conversationMessagingChannel.from) && Objects.equals(this.time, conversationMessagingChannel.time) && Objects.equals(this.dateModified, conversationMessagingChannel.dateModified) && Objects.equals(this.dateDeleted, conversationMessagingChannel.dateDeleted) && Objects.equals(this.publicMetadata, conversationMessagingChannel.publicMetadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.platform, this.type, this.messageId, this.to, this.from, this.time, this.dateModified, this.dateDeleted, this.publicMetadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationMessagingChannel {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString((Object)this.platform)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    messageId: ").append(this.toIndentedString(this.messageId)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    dateDeleted: ").append(this.toIndentedString(this.dateDeleted)).append("\n");
        sb.append("    publicMetadata: ").append(this.toIndentedString(this.publicMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=PlatformEnumDeserializer.class)
    public static enum PlatformEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TWITTER("Twitter"),
        FACEBOOK("Facebook"),
        INSTAGRAM("Instagram"),
        LINE("Line"),
        WHATSAPP("Whatsapp"),
        WEBMESSAGING("WebMessaging"),
        OPEN("Open"),
        APPLE("Apple"),
        SMS("Sms");

        private String value;

        private PlatformEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PlatformEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PlatformEnum value : PlatformEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PlatformEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PUBLIC("Public"),
        PRIVATE("Private");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class PlatformEnumDeserializer
    extends StdDeserializer<PlatformEnum> {
        public PlatformEnumDeserializer() {
            super(PlatformEnumDeserializer.class);
        }

        public PlatformEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PlatformEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

