/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.BillingProduct;
import com.mypurecloud.sdk.v2.model.NamedEntity;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

public class BillingInvoiceItem
implements Serializable {
    private String id = null;
    private BillingProduct product = null;
    private String description = null;
    private LocalDate dateTransacted = null;
    private LocalDate dateStart = null;
    private LocalDate dateEnd = null;
    private NamedEntity organization = null;
    private Integer quantity = null;
    private UnitOfMeasureEnum unitOfMeasure = null;
    private BigDecimal amount = null;

    public BillingInvoiceItem() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public BillingInvoiceItem product(BillingProduct product) {
        this.product = product;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the details of a product.")
    @JsonProperty(value="product")
    public BillingProduct getProduct() {
        return this.product;
    }

    public void setProduct(BillingProduct product) {
        this.product = product;
    }

    public BillingInvoiceItem description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Line Item Description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BillingInvoiceItem dateTransacted(LocalDate dateTransacted) {
        this.dateTransacted = dateTransacted;
        return this;
    }

    @ApiModelProperty(example="null", value="Invoice transaction date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateTransacted")
    public LocalDate getDateTransacted() {
        return this.dateTransacted;
    }

    public void setDateTransacted(LocalDate dateTransacted) {
        this.dateTransacted = dateTransacted;
    }

    public BillingInvoiceItem dateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="null", value="Invoice start date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateStart")
    public LocalDate getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
    }

    public BillingInvoiceItem dateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="Invoice end date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEnd")
    public LocalDate getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
    }

    public BillingInvoiceItem organization(NamedEntity organization) {
        this.organization = organization;
        return this;
    }

    @ApiModelProperty(example="null", value="A Genesys Cloud Organization.")
    @JsonProperty(value="organization")
    public NamedEntity getOrganization() {
        return this.organization;
    }

    public void setOrganization(NamedEntity organization) {
        this.organization = organization;
    }

    public BillingInvoiceItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(example="null", value="Quantity of the item.")
    @JsonProperty(value="quantity")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public BillingInvoiceItem unitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @ApiModelProperty(example="null", value="Unit of Measure.")
    @JsonProperty(value="unitOfMeasure")
    public UnitOfMeasureEnum getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public BillingInvoiceItem amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="null", value="Amount.")
    @JsonProperty(value="amount")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingInvoiceItem billingInvoiceItem = (BillingInvoiceItem)o;
        return Objects.equals(this.id, billingInvoiceItem.id) && Objects.equals(this.product, billingInvoiceItem.product) && Objects.equals(this.description, billingInvoiceItem.description) && Objects.equals(this.dateTransacted, billingInvoiceItem.dateTransacted) && Objects.equals(this.dateStart, billingInvoiceItem.dateStart) && Objects.equals(this.dateEnd, billingInvoiceItem.dateEnd) && Objects.equals(this.organization, billingInvoiceItem.organization) && Objects.equals(this.quantity, billingInvoiceItem.quantity) && Objects.equals((Object)this.unitOfMeasure, (Object)billingInvoiceItem.unitOfMeasure) && Objects.equals(this.amount, billingInvoiceItem.amount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.product, this.description, this.dateTransacted, this.dateStart, this.dateEnd, this.organization, this.quantity, this.unitOfMeasure, this.amount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingInvoiceItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateTransacted: ").append(this.toIndentedString(this.dateTransacted)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    dateEnd: ").append(this.toIndentedString(this.dateEnd)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString((Object)this.unitOfMeasure)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=UnitOfMeasureEnumDeserializer.class)
    public static enum UnitOfMeasureEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALL("Call"),
        CHARACTER("Character"),
        CONVERSATION("Conversation"),
        COURSE("Course"),
        DAY("Day"),
        EACH("Each"),
        EMPLOYEE("Employee"),
        ENGAGEMENT("Engagement"),
        EVENT("Event"),
        EXAM("Exam"),
        GB("GB"),
        HOUR("Hour"),
        INSTANCE("Instance"),
        INTERACTION("Interaction"),
        INVOCATION("Invocation"),
        MESSAGE("Message"),
        MILLIONCHARACTERS("MillionCharacters"),
        MINUTE("Minute"),
        PERSON("Person"),
        PHONENUMBER("PhoneNumber"),
        PORT("Port"),
        SEGMENT("Segment"),
        SESSION("Session"),
        STREAM("Stream"),
        TOKEN("Token"),
        TRANSACTION("Transaction"),
        TURN("Turn"),
        UNIT("Unit"),
        USER("User");

        private String value;

        private UnitOfMeasureEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UnitOfMeasureEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UnitOfMeasureEnum value : UnitOfMeasureEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UnitOfMeasureEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UnitOfMeasureEnumDeserializer
    extends StdDeserializer<UnitOfMeasureEnum> {
        public UnitOfMeasureEnumDeserializer() {
            super(UnitOfMeasureEnumDeserializer.class);
        }

        public UnitOfMeasureEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UnitOfMeasureEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

