/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.Customer;
import com.mypurecloud.sdk.v2.model.InvoiceAddress;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

public class BillingInvoice
implements Serializable {
    private String id = null;
    private Customer billToCustomer = null;
    private Customer shipToCustomer = null;
    private Customer soldToCustomer = null;
    private LocalDate dateInvoiced = null;
    private InvoiceAddress billToAddress = null;
    private InvoiceAddress shipToAddress = null;
    private String currencyIsoCode = null;
    private PaymentStatusEnum paymentStatus = null;
    private String paymentTerms = null;
    private String paymentLink = null;
    private String customerPoNumber = null;
    private String customerInvoiceType = null;
    private BigDecimal amount = null;

    public BillingInvoice() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public BillingInvoice billToCustomer(Customer billToCustomer) {
        this.billToCustomer = billToCustomer;
        return this;
    }

    @ApiModelProperty(example="null", value="The bill to customer.")
    @JsonProperty(value="billToCustomer")
    public Customer getBillToCustomer() {
        return this.billToCustomer;
    }

    public void setBillToCustomer(Customer billToCustomer) {
        this.billToCustomer = billToCustomer;
    }

    public BillingInvoice shipToCustomer(Customer shipToCustomer) {
        this.shipToCustomer = shipToCustomer;
        return this;
    }

    @ApiModelProperty(example="null", value="The ship to customer.")
    @JsonProperty(value="shipToCustomer")
    public Customer getShipToCustomer() {
        return this.shipToCustomer;
    }

    public void setShipToCustomer(Customer shipToCustomer) {
        this.shipToCustomer = shipToCustomer;
    }

    public BillingInvoice soldToCustomer(Customer soldToCustomer) {
        this.soldToCustomer = soldToCustomer;
        return this;
    }

    @ApiModelProperty(example="null", value="The sold to customer.")
    @JsonProperty(value="soldToCustomer")
    public Customer getSoldToCustomer() {
        return this.soldToCustomer;
    }

    public void setSoldToCustomer(Customer soldToCustomer) {
        this.soldToCustomer = soldToCustomer;
    }

    public BillingInvoice dateInvoiced(LocalDate dateInvoiced) {
        this.dateInvoiced = dateInvoiced;
        return this;
    }

    @ApiModelProperty(example="null", value="Date when the invoice was issued. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateInvoiced")
    public LocalDate getDateInvoiced() {
        return this.dateInvoiced;
    }

    public void setDateInvoiced(LocalDate dateInvoiced) {
        this.dateInvoiced = dateInvoiced;
    }

    public BillingInvoice billToAddress(InvoiceAddress billToAddress) {
        this.billToAddress = billToAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Details of the bill to address.")
    @JsonProperty(value="billToAddress")
    public InvoiceAddress getBillToAddress() {
        return this.billToAddress;
    }

    public void setBillToAddress(InvoiceAddress billToAddress) {
        this.billToAddress = billToAddress;
    }

    public BillingInvoice shipToAddress(InvoiceAddress shipToAddress) {
        this.shipToAddress = shipToAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Details of the ship to address.")
    @JsonProperty(value="shipToAddress")
    public InvoiceAddress getShipToAddress() {
        return this.shipToAddress;
    }

    public void setShipToAddress(InvoiceAddress shipToAddress) {
        this.shipToAddress = shipToAddress;
    }

    public BillingInvoice currencyIsoCode(String currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains the ISO code for any currency allowed by the organization.")
    @JsonProperty(value="currencyIsoCode")
    public String getCurrencyIsoCode() {
        return this.currencyIsoCode;
    }

    public void setCurrencyIsoCode(String currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
    }

    public BillingInvoice paymentStatus(PaymentStatusEnum paymentStatus) {
        this.paymentStatus = paymentStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Status of the payment.")
    @JsonProperty(value="paymentStatus")
    public PaymentStatusEnum getPaymentStatus() {
        return this.paymentStatus;
    }

    public void setPaymentStatus(PaymentStatusEnum paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public BillingInvoice paymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
        return this;
    }

    @ApiModelProperty(example="null", value="Payment terms.")
    @JsonProperty(value="paymentTerms")
    public String getPaymentTerms() {
        return this.paymentTerms;
    }

    public void setPaymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    public BillingInvoice paymentLink(String paymentLink) {
        this.paymentLink = paymentLink;
        return this;
    }

    @ApiModelProperty(example="null", value="Payment link.")
    @JsonProperty(value="paymentLink")
    public String getPaymentLink() {
        return this.paymentLink;
    }

    public void setPaymentLink(String paymentLink) {
        this.paymentLink = paymentLink;
    }

    public BillingInvoice customerPoNumber(String customerPoNumber) {
        this.customerPoNumber = customerPoNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Purchase Order Number.")
    @JsonProperty(value="customerPoNumber")
    public String getCustomerPoNumber() {
        return this.customerPoNumber;
    }

    public void setCustomerPoNumber(String customerPoNumber) {
        this.customerPoNumber = customerPoNumber;
    }

    public BillingInvoice customerInvoiceType(String customerInvoiceType) {
        this.customerInvoiceType = customerInvoiceType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the invoice.")
    @JsonProperty(value="customerInvoiceType")
    public String getCustomerInvoiceType() {
        return this.customerInvoiceType;
    }

    public void setCustomerInvoiceType(String customerInvoiceType) {
        this.customerInvoiceType = customerInvoiceType;
    }

    public BillingInvoice amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="null", value="Amount.")
    @JsonProperty(value="amount")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingInvoice billingInvoice = (BillingInvoice)o;
        return Objects.equals(this.id, billingInvoice.id) && Objects.equals(this.billToCustomer, billingInvoice.billToCustomer) && Objects.equals(this.shipToCustomer, billingInvoice.shipToCustomer) && Objects.equals(this.soldToCustomer, billingInvoice.soldToCustomer) && Objects.equals(this.dateInvoiced, billingInvoice.dateInvoiced) && Objects.equals(this.billToAddress, billingInvoice.billToAddress) && Objects.equals(this.shipToAddress, billingInvoice.shipToAddress) && Objects.equals(this.currencyIsoCode, billingInvoice.currencyIsoCode) && Objects.equals((Object)this.paymentStatus, (Object)billingInvoice.paymentStatus) && Objects.equals(this.paymentTerms, billingInvoice.paymentTerms) && Objects.equals(this.paymentLink, billingInvoice.paymentLink) && Objects.equals(this.customerPoNumber, billingInvoice.customerPoNumber) && Objects.equals(this.customerInvoiceType, billingInvoice.customerInvoiceType) && Objects.equals(this.amount, billingInvoice.amount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.billToCustomer, this.shipToCustomer, this.soldToCustomer, this.dateInvoiced, this.billToAddress, this.shipToAddress, this.currencyIsoCode, this.paymentStatus, this.paymentTerms, this.paymentLink, this.customerPoNumber, this.customerInvoiceType, this.amount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingInvoice {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    billToCustomer: ").append(this.toIndentedString(this.billToCustomer)).append("\n");
        sb.append("    shipToCustomer: ").append(this.toIndentedString(this.shipToCustomer)).append("\n");
        sb.append("    soldToCustomer: ").append(this.toIndentedString(this.soldToCustomer)).append("\n");
        sb.append("    dateInvoiced: ").append(this.toIndentedString(this.dateInvoiced)).append("\n");
        sb.append("    billToAddress: ").append(this.toIndentedString(this.billToAddress)).append("\n");
        sb.append("    shipToAddress: ").append(this.toIndentedString(this.shipToAddress)).append("\n");
        sb.append("    currencyIsoCode: ").append(this.toIndentedString(this.currencyIsoCode)).append("\n");
        sb.append("    paymentStatus: ").append(this.toIndentedString((Object)this.paymentStatus)).append("\n");
        sb.append("    paymentTerms: ").append(this.toIndentedString(this.paymentTerms)).append("\n");
        sb.append("    paymentLink: ").append(this.toIndentedString(this.paymentLink)).append("\n");
        sb.append("    customerPoNumber: ").append(this.toIndentedString(this.customerPoNumber)).append("\n");
        sb.append("    customerInvoiceType: ").append(this.toIndentedString(this.customerInvoiceType)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=PaymentStatusEnumDeserializer.class)
    public static enum PaymentStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PAID("Paid"),
        UNPAID("Unpaid");

        private String value;

        private PaymentStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PaymentStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PaymentStatusEnum value : PaymentStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PaymentStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PaymentStatusEnumDeserializer
    extends StdDeserializer<PaymentStatusEnum> {
        public PaymentStatusEnumDeserializer() {
            super(PaymentStatusEnumDeserializer.class);
        }

        public PaymentStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PaymentStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

