/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.CustomEventAttribute;
import com.mypurecloud.sdk.v2.model.JourneyCampaign;
import com.mypurecloud.sdk.v2.model.JourneyGeolocation;
import com.mypurecloud.sdk.v2.model.Referrer;
import com.mypurecloud.sdk.v2.model.ResponsePage;
import com.mypurecloud.sdk.v2.model.WebEventBrowser;
import com.mypurecloud.sdk.v2.model.WebEventDevice;
import com.mypurecloud.sdk.v2.model.WebEventResponseSession;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class WebEventResponse
implements Serializable {
    private String customerId = null;
    private String eventName = null;
    private String customerIdType = null;
    private ResponsePage page = null;
    private String userAgentString = null;
    private WebEventBrowser browser = null;
    private WebEventDevice device = null;
    private String searchQuery = null;
    private String ipOrganization = null;
    private JourneyGeolocation geolocation = null;
    private JourneyCampaign mktCampaign = null;
    private WebEventResponseSession session = null;
    private Referrer referrer = null;
    private Map<String, CustomEventAttribute> attributes = null;
    private Map<String, CustomEventAttribute> traits = null;
    private Boolean authenticated = null;
    private Date createdDate = null;

    public WebEventResponse customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Identifier of the customer in the source of the event.")
    @JsonProperty(value="customerId")
    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public WebEventResponse eventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Represents the action the customer performed. Event types are created for each unique event name and can be faceted on in segment and outcome conditions. A valid event name must only contain alphanumeric characters and underscores. A good event name is typically an object followed by the action performed in past tense, e.g. page_viewed, order_completed, user_registered.")
    @JsonProperty(value="eventName")
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public WebEventResponse customerIdType(String customerIdType) {
        this.customerIdType = customerIdType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of identifier for the customer ID (e.g., cookie).")
    @JsonProperty(value="customerIdType")
    public String getCustomerIdType() {
        return this.customerIdType;
    }

    public void setCustomerIdType(String customerIdType) {
        this.customerIdType = customerIdType;
    }

    public WebEventResponse page(ResponsePage page) {
        this.page = page;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The webpage where the user interaction occurred.")
    @JsonProperty(value="page")
    public ResponsePage getPage() {
        return this.page;
    }

    public void setPage(ResponsePage page) {
        this.page = page;
    }

    public WebEventResponse userAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="HTTP User-Agent string (see https://tools.ietf.org/html/rfc1945#section-10.15).")
    @JsonProperty(value="userAgentString")
    public String getUserAgentString() {
        return this.userAgentString;
    }

    public void setUserAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
    }

    public WebEventResponse browser(WebEventBrowser browser) {
        this.browser = browser;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Customer's browser.")
    @JsonProperty(value="browser")
    public WebEventBrowser getBrowser() {
        return this.browser;
    }

    public void setBrowser(WebEventBrowser browser) {
        this.browser = browser;
    }

    public WebEventResponse device(WebEventDevice device) {
        this.device = device;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Customer's device.")
    @JsonProperty(value="device")
    public WebEventDevice getDevice() {
        return this.device;
    }

    public void setDevice(WebEventDevice device) {
        this.device = device;
    }

    public WebEventResponse searchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the keywords in a customer search query.")
    @JsonProperty(value="searchQuery")
    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public WebEventResponse ipOrganization(String ipOrganization) {
        this.ipOrganization = ipOrganization;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's IP-based organization or ISP name.")
    @JsonProperty(value="ipOrganization")
    public String getIpOrganization() {
        return this.ipOrganization;
    }

    public void setIpOrganization(String ipOrganization) {
        this.ipOrganization = ipOrganization;
    }

    public WebEventResponse geolocation(JourneyGeolocation geolocation) {
        this.geolocation = geolocation;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's geolocation.")
    @JsonProperty(value="geolocation")
    public JourneyGeolocation getGeolocation() {
        return this.geolocation;
    }

    public void setGeolocation(JourneyGeolocation geolocation) {
        this.geolocation = geolocation;
    }

    public WebEventResponse mktCampaign(JourneyCampaign mktCampaign) {
        this.mktCampaign = mktCampaign;
        return this;
    }

    @ApiModelProperty(example="null", value="Urchin Tracking Module (UTM) parameters used to track the effectiveness of online marketing campaigns.")
    @JsonProperty(value="mktCampaign")
    public JourneyCampaign getMktCampaign() {
        return this.mktCampaign;
    }

    public void setMktCampaign(JourneyCampaign mktCampaign) {
        this.mktCampaign = mktCampaign;
    }

    public WebEventResponse session(WebEventResponseSession session) {
        this.session = session;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The session that the event belongs to.")
    @JsonProperty(value="session")
    public WebEventResponseSession getSession() {
        return this.session;
    }

    public void setSession(WebEventResponseSession session) {
        this.session = session;
    }

    public WebEventResponse referrer(Referrer referrer) {
        this.referrer = referrer;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifies the web page that originally generated the request for the current page being viewed.")
    @JsonProperty(value="referrer")
    public Referrer getReferrer() {
        return this.referrer;
    }

    public void setReferrer(Referrer referrer) {
        this.referrer = referrer;
    }

    public WebEventResponse attributes(Map<String, CustomEventAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="User-defined attributes associated with a particular event. These attributes provide additional context about the event. For example, items_in_cart or subscription_level.")
    @JsonProperty(value="attributes")
    public Map<String, CustomEventAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, CustomEventAttribute> attributes) {
        this.attributes = attributes;
    }

    public WebEventResponse traits(Map<String, CustomEventAttribute> traits) {
        this.traits = traits;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Traits are attributes intrinsic to the customer that may be sent in selected events, (e.g. email, lastName, cellPhone). Traits are used to collect information for identity resolution. For example, the same person might be using an application on different devices which might create two sessions with different customerIds. Additional information can be provided as traits to help link those two sessions and customers to a single external contact through common identifiers that were submitted via a form fill, message, or other input in both sessions.")
    @JsonProperty(value="traits")
    public Map<String, CustomEventAttribute> getTraits() {
        return this.traits;
    }

    public void setTraits(Map<String, CustomEventAttribute> traits) {
        this.traits = traits;
    }

    public WebEventResponse authenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates whether the event was produced during an authenticated session.")
    @JsonProperty(value="authenticated")
    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
    }

    public WebEventResponse createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="UTC timestamp indicating when the event actually took place, events older than an hour will be rejected. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebEventResponse webEventResponse = (WebEventResponse)o;
        return Objects.equals(this.customerId, webEventResponse.customerId) && Objects.equals(this.eventName, webEventResponse.eventName) && Objects.equals(this.customerIdType, webEventResponse.customerIdType) && Objects.equals(this.page, webEventResponse.page) && Objects.equals(this.userAgentString, webEventResponse.userAgentString) && Objects.equals(this.browser, webEventResponse.browser) && Objects.equals(this.device, webEventResponse.device) && Objects.equals(this.searchQuery, webEventResponse.searchQuery) && Objects.equals(this.ipOrganization, webEventResponse.ipOrganization) && Objects.equals(this.geolocation, webEventResponse.geolocation) && Objects.equals(this.mktCampaign, webEventResponse.mktCampaign) && Objects.equals(this.session, webEventResponse.session) && Objects.equals(this.referrer, webEventResponse.referrer) && Objects.equals(this.attributes, webEventResponse.attributes) && Objects.equals(this.traits, webEventResponse.traits) && Objects.equals(this.authenticated, webEventResponse.authenticated) && Objects.equals(this.createdDate, webEventResponse.createdDate);
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.eventName, this.customerIdType, this.page, this.userAgentString, this.browser, this.device, this.searchQuery, this.ipOrganization, this.geolocation, this.mktCampaign, this.session, this.referrer, this.attributes, this.traits, this.authenticated, this.createdDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebEventResponse {\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("    customerIdType: ").append(this.toIndentedString(this.customerIdType)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    userAgentString: ").append(this.toIndentedString(this.userAgentString)).append("\n");
        sb.append("    browser: ").append(this.toIndentedString(this.browser)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    searchQuery: ").append(this.toIndentedString(this.searchQuery)).append("\n");
        sb.append("    ipOrganization: ").append(this.toIndentedString(this.ipOrganization)).append("\n");
        sb.append("    geolocation: ").append(this.toIndentedString(this.geolocation)).append("\n");
        sb.append("    mktCampaign: ").append(this.toIndentedString(this.mktCampaign)).append("\n");
        sb.append("    session: ").append(this.toIndentedString(this.session)).append("\n");
        sb.append("    referrer: ").append(this.toIndentedString(this.referrer)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    traits: ").append(this.toIndentedString(this.traits)).append("\n");
        sb.append("    authenticated: ").append(this.toIndentedString(this.authenticated)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

