/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class SourceSyncResponse
implements Serializable {
    private StateEnum state = null;
    private ErrorBody error = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private AddressableEntityRef knowledgeBase = null;
    private AddressableEntityRef source = null;

    public SourceSyncResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="Sync state.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public SourceSyncResponse error(ErrorBody error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(example="null", value="Sync error.")
    @JsonProperty(value="error")
    public ErrorBody getError() {
        return this.error;
    }

    public void setError(ErrorBody error) {
        this.error = error;
    }

    public SourceSyncResponse dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Synchronization creation date-time for this source. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public SourceSyncResponse dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Synchronization last modification date-time for this source. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public SourceSyncResponse knowledgeBase(AddressableEntityRef knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
        return this;
    }

    @ApiModelProperty(example="null", value="Knowledge base to which this synchronization belongs.")
    @JsonProperty(value="knowledgeBase")
    public AddressableEntityRef getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public void setKnowledgeBase(AddressableEntityRef knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
    }

    public SourceSyncResponse source(AddressableEntityRef source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(example="null", value="Source to which this synchronization belongs.")
    @JsonProperty(value="source")
    public AddressableEntityRef getSource() {
        return this.source;
    }

    public void setSource(AddressableEntityRef source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceSyncResponse sourceSyncResponse = (SourceSyncResponse)o;
        return Objects.equals((Object)this.state, (Object)sourceSyncResponse.state) && Objects.equals(this.error, sourceSyncResponse.error) && Objects.equals(this.dateCreated, sourceSyncResponse.dateCreated) && Objects.equals(this.dateModified, sourceSyncResponse.dateModified) && Objects.equals(this.knowledgeBase, sourceSyncResponse.knowledgeBase) && Objects.equals(this.source, sourceSyncResponse.source);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.error, this.dateCreated, this.dateModified, this.knowledgeBase, this.source});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceSyncResponse {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    knowledgeBase: ").append(this.toIndentedString(this.knowledgeBase)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUCCESS("Success"),
        FAILED("Failed"),
        INPROGRESS("InProgress"),
        UNKNOWN("Unknown");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

