/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Miner;
import com.mypurecloud.sdk.v2.model.TopicPhrase;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MinerTopic
implements Serializable {
    private String id = null;
    private String name = null;
    private Miner miner = null;
    private Integer conversationCount = null;
    private Float conversationPercent = null;
    private Integer utteranceCount = null;
    private Integer phraseCount = null;
    private List<TopicPhrase> phrases = new ArrayList<TopicPhrase>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public MinerTopic name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="Topic name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="The miner to which the topic belongs.")
    @JsonProperty(value="miner")
    public Miner getMiner() {
        return this.miner;
    }

    @ApiModelProperty(example="null", value="Number of conversations where a topic has occurred.")
    @JsonProperty(value="conversationCount")
    public Integer getConversationCount() {
        return this.conversationCount;
    }

    @ApiModelProperty(example="null", value="Percentage of conversations where a topic has occurred.")
    @JsonProperty(value="conversationPercent")
    public Float getConversationPercent() {
        return this.conversationPercent;
    }

    @ApiModelProperty(example="null", value="Number of unique utterances where a topic has occurred.")
    @JsonProperty(value="utteranceCount")
    public Integer getUtteranceCount() {
        return this.utteranceCount;
    }

    @ApiModelProperty(example="null", value="Number of unique phrases (sub-utterances) where a topic has occurred.")
    @JsonProperty(value="phraseCount")
    public Integer getPhraseCount() {
        return this.phraseCount;
    }

    public MinerTopic phrases(List<TopicPhrase> phrases) {
        this.phrases = phrases;
        return this;
    }

    @ApiModelProperty(example="null", value="Phrases associated with a topic.")
    @JsonProperty(value="phrases")
    public List<TopicPhrase> getPhrases() {
        return this.phrases;
    }

    public void setPhrases(List<TopicPhrase> phrases) {
        this.phrases = phrases;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinerTopic minerTopic = (MinerTopic)o;
        return Objects.equals(this.id, minerTopic.id) && Objects.equals(this.name, minerTopic.name) && Objects.equals(this.miner, minerTopic.miner) && Objects.equals(this.conversationCount, minerTopic.conversationCount) && Objects.equals(this.conversationPercent, minerTopic.conversationPercent) && Objects.equals(this.utteranceCount, minerTopic.utteranceCount) && Objects.equals(this.phraseCount, minerTopic.phraseCount) && Objects.equals(this.phrases, minerTopic.phrases) && Objects.equals(this.selfUri, minerTopic.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.miner, this.conversationCount, this.conversationPercent, this.utteranceCount, this.phraseCount, this.phrases, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MinerTopic {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    miner: ").append(this.toIndentedString(this.miner)).append("\n");
        sb.append("    conversationCount: ").append(this.toIndentedString(this.conversationCount)).append("\n");
        sb.append("    conversationPercent: ").append(this.toIndentedString(this.conversationPercent)).append("\n");
        sb.append("    utteranceCount: ").append(this.toIndentedString(this.utteranceCount)).append("\n");
        sb.append("    phraseCount: ").append(this.toIndentedString(this.phraseCount)).append("\n");
        sb.append("    phrases: ").append(this.toIndentedString(this.phrases)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

