/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ObjectiveZone;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateObjective
implements Serializable {
    private String id = null;
    private String templateId = null;
    private List<ObjectiveZone> zones = new ArrayList<ObjectiveZone>();
    private Boolean enabled = null;
    private List<String> topicIds = new ArrayList<String>();
    private List<MediaTypesEnum> mediaTypes = new ArrayList<MediaTypesEnum>();
    private List<String> queueIds = new ArrayList<String>();
    private TopicIdsFilterTypeEnum topicIdsFilterType = null;
    private List<String> evaluationFormContextIds = new ArrayList<String>();
    private InitialDirectionEnum initialDirection = null;
    private LocalDate dateStart = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public CreateObjective templateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of this objective's base template")
    @JsonProperty(value="templateId")
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public CreateObjective zones(List<ObjectiveZone> zones) {
        this.zones = zones;
        return this;
    }

    @ApiModelProperty(example="null", value="Objective zone specifies min,max points and values for the associated metric")
    @JsonProperty(value="zones")
    public List<ObjectiveZone> getZones() {
        return this.zones;
    }

    public void setZones(List<ObjectiveZone> zones) {
        this.zones = zones;
    }

    public CreateObjective enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="A flag for whether this objective is enabled for the related metric")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public CreateObjective topicIds(List<String> topicIds) {
        this.topicIds = topicIds;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of topic ids for detected topic metrics")
    @JsonProperty(value="topicIds")
    public List<String> getTopicIds() {
        return this.topicIds;
    }

    public void setTopicIds(List<String> topicIds) {
        this.topicIds = topicIds;
    }

    public CreateObjective mediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of media types for the metric")
    @JsonProperty(value="mediaTypes")
    public List<MediaTypesEnum> getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public CreateObjective queueIds(List<String> queueIds) {
        this.queueIds = queueIds;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of queue ids for the metric")
    @JsonProperty(value="queueIds")
    public List<String> getQueueIds() {
        return this.queueIds;
    }

    public void setQueueIds(List<String> queueIds) {
        this.queueIds = queueIds;
    }

    public CreateObjective topicIdsFilterType(TopicIdsFilterTypeEnum topicIdsFilterType) {
        this.topicIdsFilterType = topicIdsFilterType;
        return this;
    }

    @ApiModelProperty(example="null", value="A filter type for topic Ids. It's only used for objectives with topicIds. Default filter behavior is \"or\".")
    @JsonProperty(value="topicIdsFilterType")
    public TopicIdsFilterTypeEnum getTopicIdsFilterType() {
        return this.topicIdsFilterType;
    }

    public void setTopicIdsFilterType(TopicIdsFilterTypeEnum topicIdsFilterType) {
        this.topicIdsFilterType = topicIdsFilterType;
    }

    public CreateObjective evaluationFormContextIds(List<String> evaluationFormContextIds) {
        this.evaluationFormContextIds = evaluationFormContextIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The ids of associated evaluation form context, for Quality Evaluation Score metrics")
    @JsonProperty(value="evaluationFormContextIds")
    public List<String> getEvaluationFormContextIds() {
        return this.evaluationFormContextIds;
    }

    public void setEvaluationFormContextIds(List<String> evaluationFormContextIds) {
        this.evaluationFormContextIds = evaluationFormContextIds;
    }

    public CreateObjective initialDirection(InitialDirectionEnum initialDirection) {
        this.initialDirection = initialDirection;
        return this;
    }

    @ApiModelProperty(example="null", value="The initial direction to filter on")
    @JsonProperty(value="initialDirection")
    public InitialDirectionEnum getInitialDirection() {
        return this.initialDirection;
    }

    public void setInitialDirection(InitialDirectionEnum initialDirection) {
        this.initialDirection = initialDirection;
    }

    public CreateObjective dateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="null", value="start date of the objective. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateStart")
    public LocalDate getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateObjective createObjective = (CreateObjective)o;
        return Objects.equals(this.id, createObjective.id) && Objects.equals(this.templateId, createObjective.templateId) && Objects.equals(this.zones, createObjective.zones) && Objects.equals(this.enabled, createObjective.enabled) && Objects.equals(this.topicIds, createObjective.topicIds) && Objects.equals(this.mediaTypes, createObjective.mediaTypes) && Objects.equals(this.queueIds, createObjective.queueIds) && Objects.equals((Object)this.topicIdsFilterType, (Object)createObjective.topicIdsFilterType) && Objects.equals(this.evaluationFormContextIds, createObjective.evaluationFormContextIds) && Objects.equals((Object)this.initialDirection, (Object)createObjective.initialDirection) && Objects.equals(this.dateStart, createObjective.dateStart);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.templateId, this.zones, this.enabled, this.topicIds, this.mediaTypes, this.queueIds, this.topicIdsFilterType, this.evaluationFormContextIds, this.initialDirection, this.dateStart});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateObjective {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    templateId: ").append(this.toIndentedString(this.templateId)).append("\n");
        sb.append("    zones: ").append(this.toIndentedString(this.zones)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    topicIds: ").append(this.toIndentedString(this.topicIds)).append("\n");
        sb.append("    mediaTypes: ").append(this.toIndentedString(this.mediaTypes)).append("\n");
        sb.append("    queueIds: ").append(this.toIndentedString(this.queueIds)).append("\n");
        sb.append("    topicIdsFilterType: ").append(this.toIndentedString((Object)this.topicIdsFilterType)).append("\n");
        sb.append("    evaluationFormContextIds: ").append(this.toIndentedString(this.evaluationFormContextIds)).append("\n");
        sb.append("    initialDirection: ").append(this.toIndentedString((Object)this.initialDirection)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TopicIdsFilterTypeEnumDeserializer.class)
    public static enum TopicIdsFilterTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AND("and"),
        OR("or");

        private String value;

        private TopicIdsFilterTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TopicIdsFilterTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TopicIdsFilterTypeEnum value : TopicIdsFilterTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TopicIdsFilterTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=InitialDirectionEnumDeserializer.class)
    public static enum InitialDirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private InitialDirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static InitialDirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (InitialDirectionEnum value : InitialDirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return InitialDirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class InitialDirectionEnumDeserializer
    extends StdDeserializer<InitialDirectionEnum> {
        public InitialDirectionEnumDeserializer() {
            super(InitialDirectionEnumDeserializer.class);
        }

        public InitialDirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return InitialDirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TopicIdsFilterTypeEnumDeserializer
    extends StdDeserializer<TopicIdsFilterTypeEnum> {
        public TopicIdsFilterTypeEnumDeserializer() {
            super(TopicIdsFilterTypeEnumDeserializer.class);
        }

        public TopicIdsFilterTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TopicIdsFilterTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MediaTypesEnumDeserializer.class)
    public static enum MediaTypesEnum {
        CALLBACK("callback"),
        CHAT("chat"),
        COBROWSE("cobrowse"),
        EMAIL("email"),
        MESSAGE("message"),
        INTERNALMESSAGE("internalmessage"),
        SCREENSHARE("screenshare"),
        UNKNOWN("unknown"),
        VIDEO("video"),
        VOICE("voice");

        private String value;

        private MediaTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypesEnum value : MediaTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypesEnumDeserializer
    extends StdDeserializer<MediaTypesEnum> {
        public MediaTypesEnumDeserializer() {
            super(MediaTypesEnumDeserializer.class);
        }

        public MediaTypesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

