/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ErrorInfo;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ContactsBulkOperationJob
implements Serializable {
    private String id = null;
    private StateEnum state = null;
    private TypeEnum type = null;
    private Long totalRecords = null;
    private Long completedRecords = null;
    private Integer percentComplete = null;
    private ErrorInfo failureReason = null;
    private String downloadURI = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique job identifier.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The job state.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    @ApiModelProperty(example="null", value="The job type.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    @ApiModelProperty(example="null", value="Total records that will be impacted by the bulk operation.")
    @JsonProperty(value="totalRecords")
    public Long getTotalRecords() {
        return this.totalRecords;
    }

    @ApiModelProperty(example="null", value="Amount of records that have been impacted by the bulk operation.")
    @JsonProperty(value="completedRecords")
    public Long getCompletedRecords() {
        return this.completedRecords;
    }

    @ApiModelProperty(example="null", value="Percentage of records that have been impacted by the bulk operation.")
    @JsonProperty(value="percentComplete")
    public Integer getPercentComplete() {
        return this.percentComplete;
    }

    @ApiModelProperty(example="null", value="Information on failure reason.")
    @JsonProperty(value="failureReason")
    public ErrorInfo getFailureReason() {
        return this.failureReason;
    }

    @ApiModelProperty(example="null", value="URI to download the original backup contacts.")
    @JsonProperty(value="downloadURI")
    public String getDownloadURI() {
        return this.downloadURI;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactsBulkOperationJob contactsBulkOperationJob = (ContactsBulkOperationJob)o;
        return Objects.equals(this.id, contactsBulkOperationJob.id) && Objects.equals((Object)this.state, (Object)contactsBulkOperationJob.state) && Objects.equals((Object)this.type, (Object)contactsBulkOperationJob.type) && Objects.equals(this.totalRecords, contactsBulkOperationJob.totalRecords) && Objects.equals(this.completedRecords, contactsBulkOperationJob.completedRecords) && Objects.equals(this.percentComplete, contactsBulkOperationJob.percentComplete) && Objects.equals(this.failureReason, contactsBulkOperationJob.failureReason) && Objects.equals(this.downloadURI, contactsBulkOperationJob.downloadURI) && Objects.equals(this.selfUri, contactsBulkOperationJob.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.type, this.totalRecords, this.completedRecords, this.percentComplete, this.failureReason, this.downloadURI, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactsBulkOperationJob {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    totalRecords: ").append(this.toIndentedString(this.totalRecords)).append("\n");
        sb.append("    completedRecords: ").append(this.toIndentedString(this.completedRecords)).append("\n");
        sb.append("    percentComplete: ").append(this.toIndentedString(this.percentComplete)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    downloadURI: ").append(this.toIndentedString(this.downloadURI)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INPROGRESS("InProgress"),
        COMPLETE("Complete"),
        FAILED("Failed");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BULKDELETE("BulkDelete"),
        BULKEDIT("BulkEdit");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

