/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.MetadataAttribute;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Article
implements Serializable {
    private String title = null;
    private String uri = null;
    private List<String> snippets = new ArrayList<String>();
    private Float confidence = null;
    private Map<String, MetadataAttribute> metadata = null;
    private AddressableEntityRef version = null;
    private List<AddressableEntityRef> variations = new ArrayList<AddressableEntityRef>();

    @ApiModelProperty(example="null", value="The article title.")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @ApiModelProperty(example="null", value="The URI for the article.")
    @JsonProperty(value="uri")
    public String getUri() {
        return this.uri;
    }

    @ApiModelProperty(example="null", value="This contains snippets of text from the article matching the query.")
    @JsonProperty(value="snippets")
    public List<String> getSnippets() {
        return this.snippets;
    }

    @ApiModelProperty(example="null", value="Value between 0 and 1. 1 corresponds to very confident, 0 to not confident at all.")
    @JsonProperty(value="confidence")
    public Float getConfidence() {
        return this.confidence;
    }

    @ApiModelProperty(example="null", value="A map that contains custom metadata about the article answer.")
    @JsonProperty(value="metadata")
    public Map<String, MetadataAttribute> getMetadata() {
        return this.metadata;
    }

    @ApiModelProperty(example="null", value="The version of the Article.")
    @JsonProperty(value="version")
    public AddressableEntityRef getVersion() {
        return this.version;
    }

    @ApiModelProperty(example="null", value="Variations of the Article.")
    @JsonProperty(value="variations")
    public List<AddressableEntityRef> getVariations() {
        return this.variations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Article article = (Article)o;
        return Objects.equals(this.title, article.title) && Objects.equals(this.uri, article.uri) && Objects.equals(this.snippets, article.snippets) && Objects.equals(this.confidence, article.confidence) && Objects.equals(this.metadata, article.metadata) && Objects.equals(this.version, article.version) && Objects.equals(this.variations, article.variations);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.uri, this.snippets, this.confidence, this.metadata, this.version, this.variations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Article {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    snippets: ").append(this.toIndentedString(this.snippets)).append("\n");
        sb.append("    confidence: ").append(this.toIndentedString(this.confidence)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

