/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Assistant;
import java.util.HashMap;
import java.util.Map;

public class PatchAssistantRequest {
    private String assistantId;
    private Assistant body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAssistantId() {
        return this.assistantId;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public PatchAssistantRequest withAssistantId(String assistantId) {
        this.setAssistantId(assistantId);
        return this;
    }

    public Assistant getBody() {
        return this.body;
    }

    public void setBody(Assistant body) {
        this.body = body;
    }

    public PatchAssistantRequest withBody(Assistant body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchAssistantRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Assistant> withHttpInfo() {
        if (this.assistantId == null) {
            throw new IllegalStateException("Missing the required parameter 'assistantId' when building request for PatchAssistantRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchAssistantRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/assistants/{assistantId}").withPathParameter("assistantId", this.assistantId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String assistantId, Assistant body) {
        return new Builder().withRequiredParams(assistantId, body);
    }

    public static class Builder {
        private final PatchAssistantRequest request = new PatchAssistantRequest();

        private Builder() {
        }

        public Builder withAssistantId(String assistantId) {
            this.request.setAssistantId(assistantId);
            return this;
        }

        public Builder withBody(Assistant body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String assistantId, Assistant body) {
            this.request.setAssistantId(assistantId);
            this.request.setBody(body);
            return this;
        }

        public PatchAssistantRequest build() {
            if (this.request.assistantId == null) {
                throw new IllegalStateException("Missing the required parameter 'assistantId' when building request for PatchAssistantRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchAssistantRequest.");
            }
            return this.request;
        }
    }
}

