/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.AlertRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchAlertingAlertRequest {
    private String alertId;
    private AlertRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAlertId() {
        return this.alertId;
    }

    public void setAlertId(String alertId) {
        this.alertId = alertId;
    }

    public PatchAlertingAlertRequest withAlertId(String alertId) {
        this.setAlertId(alertId);
        return this;
    }

    public AlertRequest getBody() {
        return this.body;
    }

    public void setBody(AlertRequest body) {
        this.body = body;
    }

    public PatchAlertingAlertRequest withBody(AlertRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchAlertingAlertRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<AlertRequest> withHttpInfo() {
        if (this.alertId == null) {
            throw new IllegalStateException("Missing the required parameter 'alertId' when building request for PatchAlertingAlertRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/alerting/alerts/{alertId}").withPathParameter("alertId", this.alertId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String alertId) {
        return new Builder().withRequiredParams(alertId);
    }

    public static class Builder {
        private final PatchAlertingAlertRequest request = new PatchAlertingAlertRequest();

        private Builder() {
        }

        public Builder withAlertId(String alertId) {
            this.request.setAlertId(alertId);
            return this;
        }

        public Builder withBody(AlertRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String alertId) {
            this.request.setAlertId(alertId);
            return this;
        }

        public PatchAlertingAlertRequest build() {
            if (this.request.alertId == null) {
                throw new IllegalStateException("Missing the required parameter 'alertId' when building request for PatchAlertingAlertRequest.");
            }
            return this.request;
        }
    }
}

