/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.EntityReference;
import com.mypurecloud.sdk.v2.model.KnowledgeGuestDocumentVersionReference;
import com.mypurecloud.sdk.v2.model.KnowledgeGuestSearchClientApplication;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class KnowledgeGuestDocumentFeedback
implements Serializable {
    private String id = null;
    private EntityReference documentVariation = null;
    private RatingEnum rating = null;
    private ReasonEnum reason = null;
    private String comment = null;
    private EntityReference search = null;
    private String sessionId = null;
    private Date dateCreated = null;
    private QueryTypeEnum queryType = null;
    private StateEnum state = null;
    private KnowledgeGuestDocumentVersionReference document = null;
    private KnowledgeGuestSearchClientApplication application = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public KnowledgeGuestDocumentFeedback documentVariation(EntityReference documentVariation) {
        this.documentVariation = documentVariation;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The variation of the document on which feedback was given.")
    @JsonProperty(value="documentVariation")
    public EntityReference getDocumentVariation() {
        return this.documentVariation;
    }

    public void setDocumentVariation(EntityReference documentVariation) {
        this.documentVariation = documentVariation;
    }

    public KnowledgeGuestDocumentFeedback rating(RatingEnum rating) {
        this.rating = rating;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Feedback rating.")
    @JsonProperty(value="rating")
    public RatingEnum getRating() {
        return this.rating;
    }

    public void setRating(RatingEnum rating) {
        this.rating = rating;
    }

    public KnowledgeGuestDocumentFeedback reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(example="null", value="Feedback reason.")
    @JsonProperty(value="reason")
    public ReasonEnum getReason() {
        return this.reason;
    }

    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public KnowledgeGuestDocumentFeedback comment(String comment) {
        this.comment = comment;
        return this;
    }

    @ApiModelProperty(example="null", value="Free-text comment of the feedback. Maximum length: 2000 characters.")
    @JsonProperty(value="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public KnowledgeGuestDocumentFeedback search(EntityReference search) {
        this.search = search;
        return this;
    }

    @ApiModelProperty(example="null", value="The search that surfaced the document on which feedback was given.")
    @JsonProperty(value="search")
    public EntityReference getSearch() {
        return this.search;
    }

    public void setSearch(EntityReference search) {
        this.search = search;
    }

    @ApiModelProperty(example="null", value="Knowledge guest session ID.")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    @ApiModelProperty(example="null", value="The date and time of the feedback. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public KnowledgeGuestDocumentFeedback queryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the query that surfaced the document on which the feedback was given.")
    @JsonProperty(value="queryType")
    public QueryTypeEnum getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
    }

    public KnowledgeGuestDocumentFeedback state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The state of the feedback.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public KnowledgeGuestDocumentFeedback document(KnowledgeGuestDocumentVersionReference document) {
        this.document = document;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The document on which feedback was given.")
    @JsonProperty(value="document")
    public KnowledgeGuestDocumentVersionReference getDocument() {
        return this.document;
    }

    public void setDocument(KnowledgeGuestDocumentVersionReference document) {
        this.document = document;
    }

    @ApiModelProperty(example="null", value="The client application from which feedback was given.")
    @JsonProperty(value="application")
    public KnowledgeGuestSearchClientApplication getApplication() {
        return this.application;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeGuestDocumentFeedback knowledgeGuestDocumentFeedback = (KnowledgeGuestDocumentFeedback)o;
        return Objects.equals(this.id, knowledgeGuestDocumentFeedback.id) && Objects.equals(this.documentVariation, knowledgeGuestDocumentFeedback.documentVariation) && Objects.equals((Object)this.rating, (Object)knowledgeGuestDocumentFeedback.rating) && Objects.equals((Object)this.reason, (Object)knowledgeGuestDocumentFeedback.reason) && Objects.equals(this.comment, knowledgeGuestDocumentFeedback.comment) && Objects.equals(this.search, knowledgeGuestDocumentFeedback.search) && Objects.equals(this.sessionId, knowledgeGuestDocumentFeedback.sessionId) && Objects.equals(this.dateCreated, knowledgeGuestDocumentFeedback.dateCreated) && Objects.equals((Object)this.queryType, (Object)knowledgeGuestDocumentFeedback.queryType) && Objects.equals((Object)this.state, (Object)knowledgeGuestDocumentFeedback.state) && Objects.equals(this.document, knowledgeGuestDocumentFeedback.document) && Objects.equals(this.application, knowledgeGuestDocumentFeedback.application);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.documentVariation, this.rating, this.reason, this.comment, this.search, this.sessionId, this.dateCreated, this.queryType, this.state, this.document, this.application});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeGuestDocumentFeedback {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    documentVariation: ").append(this.toIndentedString(this.documentVariation)).append("\n");
        sb.append("    rating: ").append(this.toIndentedString((Object)this.rating)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    search: ").append(this.toIndentedString(this.search)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    queryType: ").append(this.toIndentedString((Object)this.queryType)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=RatingEnumDeserializer.class)
    public static enum RatingEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NEGATIVE("Negative"),
        POSITIVE("Positive");

        private String value;

        private RatingEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RatingEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RatingEnum value : RatingEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RatingEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ReasonEnumDeserializer.class)
    public static enum ReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DOCUMENTCONTENT("DocumentContent"),
        SEARCHRESULTS("SearchResults");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ReasonEnum value : ReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=QueryTypeEnumDeserializer.class)
    public static enum QueryTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        ARTICLE("Article"),
        AUTOSEARCH("AutoSearch"),
        CATEGORY("Category"),
        MANUALSEARCH("ManualSearch"),
        RECOMMENDATION("Recommendation"),
        SUGGESTION("Suggestion");

        private String value;

        private QueryTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static QueryTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (QueryTypeEnum value : QueryTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return QueryTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DRAFT("Draft"),
        FINAL("Final");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class QueryTypeEnumDeserializer
    extends StdDeserializer<QueryTypeEnum> {
        public QueryTypeEnumDeserializer() {
            super(QueryTypeEnumDeserializer.class);
        }

        public QueryTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return QueryTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ReasonEnumDeserializer
    extends StdDeserializer<ReasonEnum> {
        public ReasonEnumDeserializer() {
            super(ReasonEnumDeserializer.class);
        }

        public ReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class RatingEnumDeserializer
    extends StdDeserializer<RatingEnum> {
        public RatingEnumDeserializer() {
            super(RatingEnumDeserializer.class);
        }

        public RatingEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RatingEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

