/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.FlowVersion;
import com.mypurecloud.sdk.v2.model.JsonSchemaDocument;
import com.mypurecloud.sdk.v2.model.SupportedLanguage;
import com.mypurecloud.sdk.v2.model.WritableDivision;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FlowDivisionView
implements Serializable {
    private String id = null;
    private String name = null;
    private WritableDivision division = null;
    private TypeEnum type = null;
    private String description = null;
    private JsonSchemaDocument inputSchema = null;
    private JsonSchemaDocument outputSchema = null;
    private List<SupportedLanguage> supportedLanguages = new ArrayList<SupportedLanguage>();
    private FlowVersion publishedVersion = null;
    private FlowVersion debugVersion = null;
    private String selfUri = null;

    public FlowDivisionView id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The flow identifier")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FlowDivisionView name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The flow name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FlowDivisionView division(WritableDivision division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division to which this entity belongs.")
    @JsonProperty(value="division")
    public WritableDivision getDivision() {
        return this.division;
    }

    public void setDivision(WritableDivision division) {
        this.division = division;
    }

    public FlowDivisionView type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public FlowDivisionView description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="the flow description")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FlowDivisionView inputSchema(JsonSchemaDocument inputSchema) {
        this.inputSchema = inputSchema;
        return this;
    }

    @ApiModelProperty(example="null", value="json schema describing the inputs for the flow")
    @JsonProperty(value="inputSchema")
    public JsonSchemaDocument getInputSchema() {
        return this.inputSchema;
    }

    public void setInputSchema(JsonSchemaDocument inputSchema) {
        this.inputSchema = inputSchema;
    }

    public FlowDivisionView outputSchema(JsonSchemaDocument outputSchema) {
        this.outputSchema = outputSchema;
        return this;
    }

    @ApiModelProperty(example="null", value="json schema describing the outputs for the flow")
    @JsonProperty(value="outputSchema")
    public JsonSchemaDocument getOutputSchema() {
        return this.outputSchema;
    }

    public void setOutputSchema(JsonSchemaDocument outputSchema) {
        this.outputSchema = outputSchema;
    }

    @ApiModelProperty(example="null", value="List of supported languages for the published version of the flow.")
    @JsonProperty(value="supportedLanguages")
    public List<SupportedLanguage> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public FlowDivisionView publishedVersion(FlowVersion publishedVersion) {
        this.publishedVersion = publishedVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="published version information if there is a published version")
    @JsonProperty(value="publishedVersion")
    public FlowVersion getPublishedVersion() {
        return this.publishedVersion;
    }

    public void setPublishedVersion(FlowVersion publishedVersion) {
        this.publishedVersion = publishedVersion;
    }

    public FlowDivisionView debugVersion(FlowVersion debugVersion) {
        this.debugVersion = debugVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="debug version information if there is a debug version")
    @JsonProperty(value="debugVersion")
    public FlowVersion getDebugVersion() {
        return this.debugVersion;
    }

    public void setDebugVersion(FlowVersion debugVersion) {
        this.debugVersion = debugVersion;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowDivisionView flowDivisionView = (FlowDivisionView)o;
        return Objects.equals(this.id, flowDivisionView.id) && Objects.equals(this.name, flowDivisionView.name) && Objects.equals(this.division, flowDivisionView.division) && Objects.equals((Object)this.type, (Object)flowDivisionView.type) && Objects.equals(this.description, flowDivisionView.description) && Objects.equals(this.inputSchema, flowDivisionView.inputSchema) && Objects.equals(this.outputSchema, flowDivisionView.outputSchema) && Objects.equals(this.supportedLanguages, flowDivisionView.supportedLanguages) && Objects.equals(this.publishedVersion, flowDivisionView.publishedVersion) && Objects.equals(this.debugVersion, flowDivisionView.debugVersion) && Objects.equals(this.selfUri, flowDivisionView.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.division, this.type, this.description, this.inputSchema, this.outputSchema, this.supportedLanguages, this.publishedVersion, this.debugVersion, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowDivisionView {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    inputSchema: ").append(this.toIndentedString(this.inputSchema)).append("\n");
        sb.append("    outputSchema: ").append(this.toIndentedString(this.outputSchema)).append("\n");
        sb.append("    supportedLanguages: ").append(this.toIndentedString(this.supportedLanguages)).append("\n");
        sb.append("    publishedVersion: ").append(this.toIndentedString(this.publishedVersion)).append("\n");
        sb.append("    debugVersion: ").append(this.toIndentedString(this.debugVersion)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BOT("BOT"),
        COMMONMODULE("COMMONMODULE"),
        DIGITALBOT("DIGITALBOT"),
        INBOUNDCALL("INBOUNDCALL"),
        INBOUNDCHAT("INBOUNDCHAT"),
        INBOUNDEMAIL("INBOUNDEMAIL"),
        INBOUNDSHORTMESSAGE("INBOUNDSHORTMESSAGE"),
        INQUEUECALL("INQUEUECALL"),
        INQUEUEEMAIL("INQUEUEEMAIL"),
        INQUEUESHORTMESSAGE("INQUEUESHORTMESSAGE"),
        OUTBOUNDCALL("OUTBOUNDCALL"),
        SECURECALL("SECURECALL"),
        SPEECH("SPEECH"),
        SURVEYINVITE("SURVEYINVITE"),
        VOICE("VOICE"),
        VOICEMAIL("VOICEMAIL"),
        VOICESURVEY("VOICESURVEY"),
        WORKFLOW("WORKFLOW"),
        WORKITEM("WORKITEM");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

