/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.MatchCriteria;
import com.mypurecloud.sdk.v2.model.TriggerTarget;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateTriggerRequest
implements Serializable {
    private TriggerTarget target = null;
    private Boolean enabled = null;
    private List<MatchCriteria> matchCriteria = new ArrayList<MatchCriteria>();
    private String name = null;
    private String topicName = null;
    private Integer eventTTLSeconds = null;
    private Integer delayBySeconds = null;
    private String description = null;

    public CreateTriggerRequest target(TriggerTarget target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The target to invoke when a matching event is received")
    @JsonProperty(value="target")
    public TriggerTarget getTarget() {
        return this.target;
    }

    public void setTarget(TriggerTarget target) {
        this.target = target;
    }

    public CreateTriggerRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Boolean indicating if Trigger is enabled")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public CreateTriggerRequest matchCriteria(List<MatchCriteria> matchCriteria) {
        this.matchCriteria = matchCriteria;
        return this;
    }

    @ApiModelProperty(example="null", value="The configuration for when a trigger is considered to be a match for an event. When not provided, all events will fire the trigger")
    @JsonProperty(value="matchCriteria")
    public List<MatchCriteria> getMatchCriteria() {
        return this.matchCriteria;
    }

    public void setMatchCriteria(List<MatchCriteria> matchCriteria) {
        this.matchCriteria = matchCriteria;
    }

    public CreateTriggerRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the trigger")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateTriggerRequest topicName(String topicName) {
        this.topicName = topicName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The topic that will cause the trigger to be invoked. Cannot be updated after creation. Valid topics can be found at /processautomation/triggers/topics ")
    @JsonProperty(value="topicName")
    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public CreateTriggerRequest eventTTLSeconds(Integer eventTTLSeconds) {
        this.eventTTLSeconds = eventTTLSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional length of time that events are meaningful after origination. Events older than this threshold may be dropped if the platform is delayed in processing events. Unset means events are valid indefinitely, otherwise must be set to at least 10 seconds. Only one of eventTTLSeconds or delayBySeconds can be set.")
    @JsonProperty(value="eventTTLSeconds")
    public Integer getEventTTLSeconds() {
        return this.eventTTLSeconds;
    }

    public void setEventTTLSeconds(Integer eventTTLSeconds) {
        this.eventTTLSeconds = eventTTLSeconds;
    }

    public CreateTriggerRequest delayBySeconds(Integer delayBySeconds) {
        this.delayBySeconds = delayBySeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional delay invoking target after trigger fires. Must be in the range of 60 to 900 seconds. Only one of eventTTLSeconds or delayBySeconds can be set.")
    @JsonProperty(value="delayBySeconds")
    public Integer getDelayBySeconds() {
        return this.delayBySeconds;
    }

    public void setDelayBySeconds(Integer delayBySeconds) {
        this.delayBySeconds = delayBySeconds;
    }

    public CreateTriggerRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Description of the trigger. Can be up to 512 characters in length.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTriggerRequest createTriggerRequest = (CreateTriggerRequest)o;
        return Objects.equals(this.target, createTriggerRequest.target) && Objects.equals(this.enabled, createTriggerRequest.enabled) && Objects.equals(this.matchCriteria, createTriggerRequest.matchCriteria) && Objects.equals(this.name, createTriggerRequest.name) && Objects.equals(this.topicName, createTriggerRequest.topicName) && Objects.equals(this.eventTTLSeconds, createTriggerRequest.eventTTLSeconds) && Objects.equals(this.delayBySeconds, createTriggerRequest.delayBySeconds) && Objects.equals(this.description, createTriggerRequest.description);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.enabled, this.matchCriteria, this.name, this.topicName, this.eventTTLSeconds, this.delayBySeconds, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTriggerRequest {\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    matchCriteria: ").append(this.toIndentedString(this.matchCriteria)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    topicName: ").append(this.toIndentedString(this.topicName)).append("\n");
        sb.append("    eventTTLSeconds: ").append(this.toIndentedString(this.eventTTLSeconds)).append("\n");
        sb.append("    delayBySeconds: ").append(this.toIndentedString(this.delayBySeconds)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

