/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.KnowledgeParseJobRequestPatch;
import java.util.HashMap;
import java.util.Map;

public class PatchKnowledgeKnowledgebaseParseJobRequest {
    private String knowledgeBaseId;
    private String parseJobId;
    private KnowledgeParseJobRequestPatch body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public PatchKnowledgeKnowledgebaseParseJobRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getParseJobId() {
        return this.parseJobId;
    }

    public void setParseJobId(String parseJobId) {
        this.parseJobId = parseJobId;
    }

    public PatchKnowledgeKnowledgebaseParseJobRequest withParseJobId(String parseJobId) {
        this.setParseJobId(parseJobId);
        return this;
    }

    public KnowledgeParseJobRequestPatch getBody() {
        return this.body;
    }

    public void setBody(KnowledgeParseJobRequestPatch body) {
        this.body = body;
    }

    public PatchKnowledgeKnowledgebaseParseJobRequest withBody(KnowledgeParseJobRequestPatch body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchKnowledgeKnowledgebaseParseJobRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<KnowledgeParseJobRequestPatch> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseParseJobRequest.");
        }
        if (this.parseJobId == null) {
            throw new IllegalStateException("Missing the required parameter 'parseJobId' when building request for PatchKnowledgeKnowledgebaseParseJobRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseParseJobRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/parse/jobs/{parseJobId}").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("parseJobId", this.parseJobId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String parseJobId, KnowledgeParseJobRequestPatch body) {
        return new Builder().withRequiredParams(knowledgeBaseId, parseJobId, body);
    }

    public static class Builder {
        private final PatchKnowledgeKnowledgebaseParseJobRequest request = new PatchKnowledgeKnowledgebaseParseJobRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withParseJobId(String parseJobId) {
            this.request.setParseJobId(parseJobId);
            return this;
        }

        public Builder withBody(KnowledgeParseJobRequestPatch body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String parseJobId, KnowledgeParseJobRequestPatch body) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setParseJobId(parseJobId);
            this.request.setBody(body);
            return this;
        }

        public PatchKnowledgeKnowledgebaseParseJobRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseParseJobRequest.");
            }
            if (this.request.parseJobId == null) {
                throw new IllegalStateException("Missing the required parameter 'parseJobId' when building request for PatchKnowledgeKnowledgebaseParseJobRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseParseJobRequest.");
            }
            return this.request;
        }
    }
}

