/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class MessagingEndTransferEvent
implements Serializable {
    private String eventId = null;
    private Date eventDateTime = null;
    private String conversationId = null;
    private String commandId = null;
    private FinalStateEnum finalState = null;
    private String objectCommunicationId = null;

    public MessagingEndTransferEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique (V4 UUID) eventId for this event")
    @JsonProperty(value="eventId")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public MessagingEndTransferEvent eventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A Date Time representing the time this event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="eventDateTime")
    public Date getEventDateTime() {
        return this.eventDateTime;
    }

    public void setEventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
    }

    public MessagingEndTransferEvent conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique Id (V4 UUID) identifying this conversation")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public MessagingEndTransferEvent commandId(String commandId) {
        this.commandId = commandId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id (V4 UUID) used to identify the transfer already started by the external platform.")
    @JsonProperty(value="commandId")
    public String getCommandId() {
        return this.commandId;
    }

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public MessagingEndTransferEvent finalState(FinalStateEnum finalState) {
        this.finalState = finalState;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates whether the transfer completed successfully, was cancelled, or failed for some reason.")
    @JsonProperty(value="finalState")
    public FinalStateEnum getFinalState() {
        return this.finalState;
    }

    public void setFinalState(FinalStateEnum finalState) {
        this.finalState = finalState;
    }

    public MessagingEndTransferEvent objectCommunicationId(String objectCommunicationId) {
        this.objectCommunicationId = objectCommunicationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id (V4 UUID) of the communication that was being transferred.")
    @JsonProperty(value="objectCommunicationId")
    public String getObjectCommunicationId() {
        return this.objectCommunicationId;
    }

    public void setObjectCommunicationId(String objectCommunicationId) {
        this.objectCommunicationId = objectCommunicationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingEndTransferEvent messagingEndTransferEvent = (MessagingEndTransferEvent)o;
        return Objects.equals(this.eventId, messagingEndTransferEvent.eventId) && Objects.equals(this.eventDateTime, messagingEndTransferEvent.eventDateTime) && Objects.equals(this.conversationId, messagingEndTransferEvent.conversationId) && Objects.equals(this.commandId, messagingEndTransferEvent.commandId) && Objects.equals((Object)this.finalState, (Object)messagingEndTransferEvent.finalState) && Objects.equals(this.objectCommunicationId, messagingEndTransferEvent.objectCommunicationId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventId, this.eventDateTime, this.conversationId, this.commandId, this.finalState, this.objectCommunicationId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessagingEndTransferEvent {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventDateTime: ").append(this.toIndentedString(this.eventDateTime)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    commandId: ").append(this.toIndentedString(this.commandId)).append("\n");
        sb.append("    finalState: ").append(this.toIndentedString((Object)this.finalState)).append("\n");
        sb.append("    objectCommunicationId: ").append(this.toIndentedString(this.objectCommunicationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FinalStateEnumDeserializer.class)
    public static enum FinalStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COMPLETED("Completed"),
        CANCELED("Canceled"),
        FAILED("Failed");

        private String value;

        private FinalStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FinalStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FinalStateEnum value : FinalStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FinalStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FinalStateEnumDeserializer
    extends StdDeserializer<FinalStateEnum> {
        public FinalStateEnumDeserializer() {
            super(FinalStateEnumDeserializer.class);
        }

        public FinalStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FinalStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

