/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.FlowHealthErrorInfo;
import com.mypurecloud.sdk.v2.model.LocaleFlowVersionInfo;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class LocaleInfo
implements Serializable {
    private StatusEnum status = null;
    private FlowHealthErrorInfo errorInfo = null;
    private LocaleFlowVersionInfo flowVersionInfo = null;

    public LocaleInfo status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="Status of health computation for this flow version.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public LocaleInfo errorInfo(FlowHealthErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Error details for the flow version, if any.")
    @JsonProperty(value="errorInfo")
    public FlowHealthErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(FlowHealthErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    public LocaleInfo flowVersionInfo(LocaleFlowVersionInfo flowVersionInfo) {
        this.flowVersionInfo = flowVersionInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Info about given flow version.")
    @JsonProperty(value="flowVersionInfo")
    public LocaleFlowVersionInfo getFlowVersionInfo() {
        return this.flowVersionInfo;
    }

    public void setFlowVersionInfo(LocaleFlowVersionInfo flowVersionInfo) {
        this.flowVersionInfo = flowVersionInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocaleInfo localeInfo = (LocaleInfo)o;
        return Objects.equals((Object)this.status, (Object)localeInfo.status) && Objects.equals(this.errorInfo, localeInfo.errorInfo) && Objects.equals(this.flowVersionInfo, localeInfo.flowVersionInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.errorInfo, this.flowVersionInfo});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LocaleInfo {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    errorInfo: ").append(this.toIndentedString(this.errorInfo)).append("\n");
        sb.append("    flowVersionInfo: ").append(this.toIndentedString(this.flowVersionInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed"),
        ERROR("Error");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

