/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Activity code data")
public class ActivityCode
implements Serializable {
    private String name = null;
    private Boolean isActive = null;
    private Boolean isDefault = null;
    private CategoryEnum category = null;
    private Integer lengthInMinutes = null;
    private Boolean countsAsPaidTime = null;
    private Boolean countsAsWorkTime = null;
    private Boolean isAgentTimeOffSelectable = null;

    public ActivityCode name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The activity code's name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ActivityCode isActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this activity code is active or only used for historical schedules")
    @JsonProperty(value="isActive")
    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public ActivityCode isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this is a default activity code")
    @JsonProperty(value="isDefault")
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public ActivityCode category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(example="null", value="The activity code's category")
    @JsonProperty(value="category")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public ActivityCode lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The default length of the activity in minutes")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public ActivityCode countsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether an agent is paid while performing this activity")
    @JsonProperty(value="countsAsPaidTime")
    public Boolean getCountsAsPaidTime() {
        return this.countsAsPaidTime;
    }

    public void setCountsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
    }

    public ActivityCode countsAsWorkTime(Boolean countsAsWorkTime) {
        this.countsAsWorkTime = countsAsWorkTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether or not the activity should be counted as work time")
    @JsonProperty(value="countsAsWorkTime")
    public Boolean getCountsAsWorkTime() {
        return this.countsAsWorkTime;
    }

    public void setCountsAsWorkTime(Boolean countsAsWorkTime) {
        this.countsAsWorkTime = countsAsWorkTime;
    }

    public ActivityCode isAgentTimeOffSelectable(Boolean isAgentTimeOffSelectable) {
        this.isAgentTimeOffSelectable = isAgentTimeOffSelectable;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether an agent can select this activity code when creating or editing a time off request")
    @JsonProperty(value="isAgentTimeOffSelectable")
    public Boolean getIsAgentTimeOffSelectable() {
        return this.isAgentTimeOffSelectable;
    }

    public void setIsAgentTimeOffSelectable(Boolean isAgentTimeOffSelectable) {
        this.isAgentTimeOffSelectable = isAgentTimeOffSelectable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityCode activityCode = (ActivityCode)o;
        return Objects.equals(this.name, activityCode.name) && Objects.equals(this.isActive, activityCode.isActive) && Objects.equals(this.isDefault, activityCode.isDefault) && Objects.equals((Object)this.category, (Object)activityCode.category) && Objects.equals(this.lengthInMinutes, activityCode.lengthInMinutes) && Objects.equals(this.countsAsPaidTime, activityCode.countsAsPaidTime) && Objects.equals(this.countsAsWorkTime, activityCode.countsAsWorkTime) && Objects.equals(this.isAgentTimeOffSelectable, activityCode.isAgentTimeOffSelectable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.isActive, this.isDefault, this.category, this.lengthInMinutes, this.countsAsPaidTime, this.countsAsWorkTime, this.isAgentTimeOffSelectable});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityCode {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    isActive: ").append(this.toIndentedString(this.isActive)).append("\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    countsAsPaidTime: ").append(this.toIndentedString(this.countsAsPaidTime)).append("\n");
        sb.append("    countsAsWorkTime: ").append(this.toIndentedString(this.countsAsWorkTime)).append("\n");
        sb.append("    isAgentTimeOffSelectable: ").append(this.toIndentedString(this.isAgentTimeOffSelectable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ONQUEUEWORK("OnQueueWork"),
        BREAK("Break"),
        MEAL("Meal"),
        MEETING("Meeting"),
        OFFQUEUEWORK("OffQueueWork"),
        TIMEOFF("TimeOff"),
        TRAINING("Training"),
        UNAVAILABLE("Unavailable"),
        UNSCHEDULED("Unscheduled");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CategoryEnum value : CategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

