/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.UserRoutingSkillPost;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PostUserRoutingskillsRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String userId;
    private UserRoutingSkillPost body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PostUserRoutingskillsRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public UserRoutingSkillPost getBody() {
        return this.body;
    }

    public void setBody(UserRoutingSkillPost body) {
        this.body = body;
    }

    public PostUserRoutingskillsRequest withBody(UserRoutingSkillPost body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostUserRoutingskillsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<UserRoutingSkillPost> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PostUserRoutingskillsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostUserRoutingskillsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/users/{userId}/routingskills").withPathParameter("userId", this.userId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, UserRoutingSkillPost body) {
        return new Builder().withRequiredParams(userId, body);
    }

    public static class Builder {
        private final PostUserRoutingskillsRequest request = new PostUserRoutingskillsRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withBody(UserRoutingSkillPost body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String userId, UserRoutingSkillPost body) {
            this.request.setUserId(userId);
            this.request.setBody(body);
            return this;
        }

        public PostUserRoutingskillsRequest build() {
            return this.request;
        }
    }
}

