/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class OutcomeEventScore
implements Serializable {
    private AddressableEntityRef outcome = null;
    private Float sessionMaxProbability = null;
    private Float probability = null;
    private Integer percentile = null;
    private Integer sessionMaxPercentile = null;
    private Float quantile = null;
    private Float sessionMaxQuantile = null;

    public OutcomeEventScore outcome(AddressableEntityRef outcome) {
        this.outcome = outcome;
        return this;
    }

    @ApiModelProperty(example="null", value="The outcome that the score was calculated for.")
    @JsonProperty(value="outcome")
    public AddressableEntityRef getOutcome() {
        return this.outcome;
    }

    public void setOutcome(AddressableEntityRef outcome) {
        this.outcome = outcome;
    }

    public OutcomeEventScore sessionMaxProbability(Float sessionMaxProbability) {
        this.sessionMaxProbability = sessionMaxProbability;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the max probability reached in the session.")
    @JsonProperty(value="sessionMaxProbability")
    public Float getSessionMaxProbability() {
        return this.sessionMaxProbability;
    }

    public void setSessionMaxProbability(Float sessionMaxProbability) {
        this.sessionMaxProbability = sessionMaxProbability;
    }

    public OutcomeEventScore probability(Float probability) {
        this.probability = probability;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the likelihood of a customer reaching or achieving a given outcome.")
    @JsonProperty(value="probability")
    public Float getProbability() {
        return this.probability;
    }

    public void setProbability(Float probability) {
        this.probability = probability;
    }

    public OutcomeEventScore percentile(Integer percentile) {
        this.percentile = percentile;
        return this;
    }

    @ApiModelProperty(example="null", value="(Deprecated: use the 'quantile' field instead) Represents the predicted probability's percentile score when compared with all other generated probabilities for a given outcome.")
    @JsonProperty(value="percentile")
    public Integer getPercentile() {
        return this.percentile;
    }

    public void setPercentile(Integer percentile) {
        this.percentile = percentile;
    }

    public OutcomeEventScore sessionMaxPercentile(Integer sessionMaxPercentile) {
        this.sessionMaxPercentile = sessionMaxPercentile;
        return this;
    }

    @ApiModelProperty(example="null", value="(Deprecated: use the 'quantile' field instead) Represents the maximum likelihood percentile score reached for a given outcome by the current session.")
    @JsonProperty(value="sessionMaxPercentile")
    public Integer getSessionMaxPercentile() {
        return this.sessionMaxPercentile;
    }

    public void setSessionMaxPercentile(Integer sessionMaxPercentile) {
        this.sessionMaxPercentile = sessionMaxPercentile;
    }

    public OutcomeEventScore quantile(Float quantile) {
        this.quantile = quantile;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the quantity of sessions that have a maximum probability less than the predicted probability.")
    @JsonProperty(value="quantile")
    public Float getQuantile() {
        return this.quantile;
    }

    public void setQuantile(Float quantile) {
        this.quantile = quantile;
    }

    public OutcomeEventScore sessionMaxQuantile(Float sessionMaxQuantile) {
        this.sessionMaxQuantile = sessionMaxQuantile;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the quantity of sessions that have a maximum probability less than the predicted session max probability.")
    @JsonProperty(value="sessionMaxQuantile")
    public Float getSessionMaxQuantile() {
        return this.sessionMaxQuantile;
    }

    public void setSessionMaxQuantile(Float sessionMaxQuantile) {
        this.sessionMaxQuantile = sessionMaxQuantile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutcomeEventScore outcomeEventScore = (OutcomeEventScore)o;
        return Objects.equals(this.outcome, outcomeEventScore.outcome) && Objects.equals(this.sessionMaxProbability, outcomeEventScore.sessionMaxProbability) && Objects.equals(this.probability, outcomeEventScore.probability) && Objects.equals(this.percentile, outcomeEventScore.percentile) && Objects.equals(this.sessionMaxPercentile, outcomeEventScore.sessionMaxPercentile) && Objects.equals(this.quantile, outcomeEventScore.quantile) && Objects.equals(this.sessionMaxQuantile, outcomeEventScore.sessionMaxQuantile);
    }

    public int hashCode() {
        return Objects.hash(this.outcome, this.sessionMaxProbability, this.probability, this.percentile, this.sessionMaxPercentile, this.quantile, this.sessionMaxQuantile);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OutcomeEventScore {\n");
        sb.append("    outcome: ").append(this.toIndentedString(this.outcome)).append("\n");
        sb.append("    sessionMaxProbability: ").append(this.toIndentedString(this.sessionMaxProbability)).append("\n");
        sb.append("    probability: ").append(this.toIndentedString(this.probability)).append("\n");
        sb.append("    percentile: ").append(this.toIndentedString(this.percentile)).append("\n");
        sb.append("    sessionMaxPercentile: ").append(this.toIndentedString(this.sessionMaxPercentile)).append("\n");
        sb.append("    quantile: ").append(this.toIndentedString(this.quantile)).append("\n");
        sb.append("    sessionMaxQuantile: ").append(this.toIndentedString(this.sessionMaxQuantile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

