/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.PredictorSchedule;
import com.mypurecloud.sdk.v2.model.PredictorWorkloadBalancing;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class PatchPredictorRequest
implements Serializable {
    private Integer routingTimeoutSeconds = null;
    private PredictorSchedule schedule = null;
    private PredictorWorkloadBalancing workloadBalancingConfig = null;

    public PatchPredictorRequest routingTimeoutSeconds(Integer routingTimeoutSeconds) {
        this.routingTimeoutSeconds = routingTimeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of seconds allocated to predictive routing before attempting a different routing method. This is a value between 12 and 900 seconds.")
    @JsonProperty(value="routingTimeoutSeconds")
    public Integer getRoutingTimeoutSeconds() {
        return this.routingTimeoutSeconds;
    }

    public void setRoutingTimeoutSeconds(Integer routingTimeoutSeconds) {
        this.routingTimeoutSeconds = routingTimeoutSeconds;
    }

    public PatchPredictorRequest schedule(PredictorSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(example="null", value="The predictor schedule that determines when the predictor is used for routing interactions.")
    @JsonProperty(value="schedule")
    public PredictorSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(PredictorSchedule schedule) {
        this.schedule = schedule;
    }

    public PatchPredictorRequest workloadBalancingConfig(PredictorWorkloadBalancing workloadBalancingConfig) {
        this.workloadBalancingConfig = workloadBalancingConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="The predictor balancing configuration to enable workload balancing")
    @JsonProperty(value="workloadBalancingConfig")
    public PredictorWorkloadBalancing getWorkloadBalancingConfig() {
        return this.workloadBalancingConfig;
    }

    public void setWorkloadBalancingConfig(PredictorWorkloadBalancing workloadBalancingConfig) {
        this.workloadBalancingConfig = workloadBalancingConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchPredictorRequest patchPredictorRequest = (PatchPredictorRequest)o;
        return Objects.equals(this.routingTimeoutSeconds, patchPredictorRequest.routingTimeoutSeconds) && Objects.equals(this.schedule, patchPredictorRequest.schedule) && Objects.equals(this.workloadBalancingConfig, patchPredictorRequest.workloadBalancingConfig);
    }

    public int hashCode() {
        return Objects.hash(this.routingTimeoutSeconds, this.schedule, this.workloadBalancingConfig);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatchPredictorRequest {\n");
        sb.append("    routingTimeoutSeconds: ").append(this.toIndentedString(this.routingTimeoutSeconds)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    workloadBalancingConfig: ").append(this.toIndentedString(this.workloadBalancingConfig)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

