/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class MediaRtpStatistics
implements Serializable {
    private Integer packetsReceived = null;
    private Integer packetsSent = null;
    private Integer rtpEventsReceived = null;
    private Integer rtpEventsSent = null;
    private Double estimatedAverageMos = null;

    public MediaRtpStatistics packetsReceived(Integer packetsReceived) {
        this.packetsReceived = packetsReceived;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of packets received, including all invalid, duplicate, and discarded packets")
    @JsonProperty(value="packetsReceived")
    public Integer getPacketsReceived() {
        return this.packetsReceived;
    }

    public void setPacketsReceived(Integer packetsReceived) {
        this.packetsReceived = packetsReceived;
    }

    public MediaRtpStatistics packetsSent(Integer packetsSent) {
        this.packetsSent = packetsSent;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of packets sent")
    @JsonProperty(value="packetsSent")
    public Integer getPacketsSent() {
        return this.packetsSent;
    }

    public void setPacketsSent(Integer packetsSent) {
        this.packetsSent = packetsSent;
    }

    public MediaRtpStatistics rtpEventsReceived(Integer rtpEventsReceived) {
        this.rtpEventsReceived = rtpEventsReceived;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of RFC#2833 packets received")
    @JsonProperty(value="rtpEventsReceived")
    public Integer getRtpEventsReceived() {
        return this.rtpEventsReceived;
    }

    public void setRtpEventsReceived(Integer rtpEventsReceived) {
        this.rtpEventsReceived = rtpEventsReceived;
    }

    public MediaRtpStatistics rtpEventsSent(Integer rtpEventsSent) {
        this.rtpEventsSent = rtpEventsSent;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of RFC#2833 packets sent")
    @JsonProperty(value="rtpEventsSent")
    public Integer getRtpEventsSent() {
        return this.rtpEventsSent;
    }

    public void setRtpEventsSent(Integer rtpEventsSent) {
        this.rtpEventsSent = rtpEventsSent;
    }

    public MediaRtpStatistics estimatedAverageMos(Double estimatedAverageMos) {
        this.estimatedAverageMos = estimatedAverageMos;
        return this;
    }

    @ApiModelProperty(example="null", value="The estimated average MOS score")
    @JsonProperty(value="estimatedAverageMos")
    public Double getEstimatedAverageMos() {
        return this.estimatedAverageMos;
    }

    public void setEstimatedAverageMos(Double estimatedAverageMos) {
        this.estimatedAverageMos = estimatedAverageMos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaRtpStatistics mediaRtpStatistics = (MediaRtpStatistics)o;
        return Objects.equals(this.packetsReceived, mediaRtpStatistics.packetsReceived) && Objects.equals(this.packetsSent, mediaRtpStatistics.packetsSent) && Objects.equals(this.rtpEventsReceived, mediaRtpStatistics.rtpEventsReceived) && Objects.equals(this.rtpEventsSent, mediaRtpStatistics.rtpEventsSent) && Objects.equals(this.estimatedAverageMos, mediaRtpStatistics.estimatedAverageMos);
    }

    public int hashCode() {
        return Objects.hash(this.packetsReceived, this.packetsSent, this.rtpEventsReceived, this.rtpEventsSent, this.estimatedAverageMos);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaRtpStatistics {\n");
        sb.append("    packetsReceived: ").append(this.toIndentedString(this.packetsReceived)).append("\n");
        sb.append("    packetsSent: ").append(this.toIndentedString(this.packetsSent)).append("\n");
        sb.append("    rtpEventsReceived: ").append(this.toIndentedString(this.rtpEventsReceived)).append("\n");
        sb.append("    rtpEventsSent: ").append(this.toIndentedString(this.rtpEventsSent)).append("\n");
        sb.append("    estimatedAverageMos: ").append(this.toIndentedString(this.estimatedAverageMos)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

