/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.AudioState;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class InitialConfiguration
implements Serializable {
    private AudioState audioState = null;
    private Boolean alerting = null;
    private Boolean inbound = null;
    private String invitedBy = null;
    private Boolean recordingActive = null;
    private Map<String, String> additionalInfo = null;

    public InitialConfiguration audioState(AudioState audioState) {
        this.audioState = audioState;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates the initial audio state for the communication.")
    @JsonProperty(value="audioState")
    public AudioState getAudioState() {
        return this.audioState;
    }

    public void setAudioState(AudioState audioState) {
        this.audioState = audioState;
    }

    public InitialConfiguration alerting(Boolean alerting) {
        this.alerting = alerting;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates that this communication's initial state is alerting. If false, the communication started in a connected state.")
    @JsonProperty(value="alerting")
    public Boolean getAlerting() {
        return this.alerting;
    }

    public void setAlerting(Boolean alerting) {
        this.alerting = alerting;
    }

    public InitialConfiguration inbound(Boolean inbound) {
        this.inbound = inbound;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates the direction of this communication with respect to the contact center. `true` means the communication is INBOUND. `false` means the communication is OUTBOUND.")
    @JsonProperty(value="inbound")
    public Boolean getInbound() {
        return this.inbound;
    }

    public void setInbound(Boolean inbound) {
        this.inbound = inbound;
    }

    public InitialConfiguration invitedBy(String invitedBy) {
        this.invitedBy = invitedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the communication (the \"peer\") that \"invited\" this communication, if this occurred.")
    @JsonProperty(value="invitedBy")
    public String getInvitedBy() {
        return this.invitedBy;
    }

    public void setInvitedBy(String invitedBy) {
        this.invitedBy = invitedBy;
    }

    public InitialConfiguration recordingActive(Boolean recordingActive) {
        this.recordingActive = recordingActive;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether recording is active for this communication at creation.")
    @JsonProperty(value="recordingActive")
    public Boolean getRecordingActive() {
        return this.recordingActive;
    }

    public void setRecordingActive(Boolean recordingActive) {
        this.recordingActive = recordingActive;
    }

    public InitialConfiguration additionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional metadata about this session which should be recorded by the platform but which will not be indexed or searchable. Primarily for diagnostic value. Any information that needs to be accessible through other components like Analytics should be moved to dedicated fields.")
    @JsonProperty(value="additionalInfo")
    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InitialConfiguration initialConfiguration = (InitialConfiguration)o;
        return Objects.equals(this.audioState, initialConfiguration.audioState) && Objects.equals(this.alerting, initialConfiguration.alerting) && Objects.equals(this.inbound, initialConfiguration.inbound) && Objects.equals(this.invitedBy, initialConfiguration.invitedBy) && Objects.equals(this.recordingActive, initialConfiguration.recordingActive) && Objects.equals(this.additionalInfo, initialConfiguration.additionalInfo);
    }

    public int hashCode() {
        return Objects.hash(this.audioState, this.alerting, this.inbound, this.invitedBy, this.recordingActive, this.additionalInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InitialConfiguration {\n");
        sb.append("    audioState: ").append(this.toIndentedString(this.audioState)).append("\n");
        sb.append("    alerting: ").append(this.toIndentedString(this.alerting)).append("\n");
        sb.append("    inbound: ").append(this.toIndentedString(this.inbound)).append("\n");
        sb.append("    invitedBy: ").append(this.toIndentedString(this.invitedBy)).append("\n");
        sb.append("    recordingActive: ").append(this.toIndentedString(this.recordingActive)).append("\n");
        sb.append("    additionalInfo: ").append(this.toIndentedString(this.additionalInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

