/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ConversationNormalizedMessage;
import com.mypurecloud.sdk.v2.model.MessageMedia;
import com.mypurecloud.sdk.v2.model.MessageSticker;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class MessageData
implements Serializable {
    private String id = null;
    private String name = null;
    private String providerMessageId = null;
    private Date timestamp = null;
    private String fromAddress = null;
    private String toAddress = null;
    private DirectionEnum direction = null;
    private MessengerTypeEnum messengerType = null;
    private String textBody = null;
    private StatusEnum status = null;
    private List<MessageMedia> media = new ArrayList<MessageMedia>();
    private List<MessageSticker> stickers = new ArrayList<MessageSticker>();
    private ConversationNormalizedMessage normalizedMessage = null;
    private List<ConversationNormalizedMessage> normalizedReceipts = new ArrayList<ConversationNormalizedMessage>();
    private User createdBy = null;
    private String conversationId = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public MessageData name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MessageData providerMessageId(String providerMessageId) {
        this.providerMessageId = providerMessageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique identifier of the message from provider")
    @JsonProperty(value="providerMessageId")
    public String getProviderMessageId() {
        return this.providerMessageId;
    }

    public void setProviderMessageId(String providerMessageId) {
        this.providerMessageId = providerMessageId;
    }

    public MessageData timestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The time when the message was received or sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="timestamp")
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public MessageData fromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="The sender of the text message.")
    @JsonProperty(value="fromAddress")
    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public MessageData toAddress(String toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="The recipient of the text message.")
    @JsonProperty(value="toAddress")
    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public MessageData direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The direction of the message.")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public MessageData messengerType(MessengerTypeEnum messengerType) {
        this.messengerType = messengerType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of text messenger.")
    @JsonProperty(value="messengerType")
    public MessengerTypeEnum getMessengerType() {
        return this.messengerType;
    }

    public void setMessengerType(MessengerTypeEnum messengerType) {
        this.messengerType = messengerType;
    }

    public MessageData textBody(String textBody) {
        this.textBody = textBody;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The body of the text message. (Deprecated - Instead use normalizedMessage.text)")
    @JsonProperty(value="textBody")
    public String getTextBody() {
        return this.textBody;
    }

    public void setTextBody(String textBody) {
        this.textBody = textBody;
    }

    public MessageData status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The status of the message.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public MessageData media(List<MessageMedia> media) {
        this.media = media;
        return this;
    }

    @ApiModelProperty(example="null", value="The media details associated to a message. (Deprecated - Instead use normalizedMessage.content[index].attachment)")
    @JsonProperty(value="media")
    public List<MessageMedia> getMedia() {
        return this.media;
    }

    public void setMedia(List<MessageMedia> media) {
        this.media = media;
    }

    public MessageData stickers(List<MessageSticker> stickers) {
        this.stickers = stickers;
        return this;
    }

    @ApiModelProperty(example="null", value="The sticker details associated to a message. (Deprecated - Instead use normalizedMessage.content[index].attachment")
    @JsonProperty(value="stickers")
    public List<MessageSticker> getStickers() {
        return this.stickers;
    }

    public void setStickers(List<MessageSticker> stickers) {
        this.stickers = stickers;
    }

    @ApiModelProperty(example="null", value="The message into normalized format")
    @JsonProperty(value="normalizedMessage")
    public ConversationNormalizedMessage getNormalizedMessage() {
        return this.normalizedMessage;
    }

    @ApiModelProperty(example="null", value="The delivery event associated with this message in normalized format, if the message direction was outbound")
    @JsonProperty(value="normalizedReceipts")
    public List<ConversationNormalizedMessage> getNormalizedReceipts() {
        return this.normalizedReceipts;
    }

    public MessageData createdBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User who sent this message.")
    @JsonProperty(value="createdBy")
    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public MessageData conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the conversation of this message.")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageData messageData = (MessageData)o;
        return Objects.equals(this.id, messageData.id) && Objects.equals(this.name, messageData.name) && Objects.equals(this.providerMessageId, messageData.providerMessageId) && Objects.equals(this.timestamp, messageData.timestamp) && Objects.equals(this.fromAddress, messageData.fromAddress) && Objects.equals(this.toAddress, messageData.toAddress) && Objects.equals((Object)this.direction, (Object)messageData.direction) && Objects.equals((Object)this.messengerType, (Object)messageData.messengerType) && Objects.equals(this.textBody, messageData.textBody) && Objects.equals((Object)this.status, (Object)messageData.status) && Objects.equals(this.media, messageData.media) && Objects.equals(this.stickers, messageData.stickers) && Objects.equals(this.normalizedMessage, messageData.normalizedMessage) && Objects.equals(this.normalizedReceipts, messageData.normalizedReceipts) && Objects.equals(this.createdBy, messageData.createdBy) && Objects.equals(this.conversationId, messageData.conversationId) && Objects.equals(this.selfUri, messageData.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.providerMessageId, this.timestamp, this.fromAddress, this.toAddress, this.direction, this.messengerType, this.textBody, this.status, this.media, this.stickers, this.normalizedMessage, this.normalizedReceipts, this.createdBy, this.conversationId, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageData {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    providerMessageId: ").append(this.toIndentedString(this.providerMessageId)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    messengerType: ").append(this.toIndentedString((Object)this.messengerType)).append("\n");
        sb.append("    textBody: ").append(this.toIndentedString(this.textBody)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    media: ").append(this.toIndentedString(this.media)).append("\n");
        sb.append("    stickers: ").append(this.toIndentedString(this.stickers)).append("\n");
        sb.append("    normalizedMessage: ").append(this.toIndentedString(this.normalizedMessage)).append("\n");
        sb.append("    normalizedReceipts: ").append(this.toIndentedString(this.normalizedReceipts)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MessengerTypeEnumDeserializer.class)
    public static enum MessengerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SMS("sms"),
        FACEBOOK("facebook"),
        TWITTER("twitter"),
        LINE("line"),
        WHATSAPP("whatsapp"),
        WEBMESSAGING("webmessaging"),
        INSTAGRAM("instagram"),
        OPEN("open");

        private String value;

        private MessengerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MessengerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MessengerTypeEnum value : MessengerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MessengerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUEUED("queued"),
        SENT("sent"),
        FAILED("failed"),
        RECEIVED("received"),
        DELIVERY_SUCCESS("delivery-success"),
        DELIVERY_FAILED("delivery-failed"),
        READ("read"),
        REMOVED("removed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MessengerTypeEnumDeserializer
    extends StdDeserializer<MessengerTypeEnum> {
        public MessengerTypeEnumDeserializer() {
            super(MessengerTypeEnumDeserializer.class);
        }

        public MessengerTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MessengerTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

