/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Source;
import java.util.HashMap;
import java.util.Map;

public class PutPresenceSourceRequest {
    private String sourceId;
    private Source body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public PutPresenceSourceRequest withSourceId(String sourceId) {
        this.setSourceId(sourceId);
        return this;
    }

    public Source getBody() {
        return this.body;
    }

    public void setBody(Source body) {
        this.body = body;
    }

    public PutPresenceSourceRequest withBody(Source body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutPresenceSourceRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Source> withHttpInfo() {
        if (this.sourceId == null) {
            throw new IllegalStateException("Missing the required parameter 'sourceId' when building request for PutPresenceSourceRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutPresenceSourceRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/presence/sources/{sourceId}").withPathParameter("sourceId", this.sourceId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String sourceId, Source body) {
        return new Builder().withRequiredParams(sourceId, body);
    }

    public static class Builder {
        private final PutPresenceSourceRequest request = new PutPresenceSourceRequest();

        private Builder() {
        }

        public Builder withSourceId(String sourceId) {
            this.request.setSourceId(sourceId);
            return this;
        }

        public Builder withBody(Source body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String sourceId, Source body) {
            this.request.setSourceId(sourceId);
            this.request.setBody(body);
            return this;
        }

        public PutPresenceSourceRequest build() {
            if (this.request.sourceId == null) {
                throw new IllegalStateException("Missing the required parameter 'sourceId' when building request for PutPresenceSourceRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutPresenceSourceRequest.");
            }
            return this.request;
        }
    }
}

