/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ApiUsageClientQuery;
import java.util.HashMap;
import java.util.Map;

public class PostOauthClientUsageQueryRequest {
    private String clientId;
    private ApiUsageClientQuery body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public PostOauthClientUsageQueryRequest withClientId(String clientId) {
        this.setClientId(clientId);
        return this;
    }

    public ApiUsageClientQuery getBody() {
        return this.body;
    }

    public void setBody(ApiUsageClientQuery body) {
        this.body = body;
    }

    public PostOauthClientUsageQueryRequest withBody(ApiUsageClientQuery body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostOauthClientUsageQueryRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ApiUsageClientQuery> withHttpInfo() {
        if (this.clientId == null) {
            throw new IllegalStateException("Missing the required parameter 'clientId' when building request for PostOauthClientUsageQueryRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostOauthClientUsageQueryRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/oauth/clients/{clientId}/usage/query").withPathParameter("clientId", this.clientId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String clientId, ApiUsageClientQuery body) {
        return new Builder().withRequiredParams(clientId, body);
    }

    public static class Builder {
        private final PostOauthClientUsageQueryRequest request = new PostOauthClientUsageQueryRequest();

        private Builder() {
        }

        public Builder withClientId(String clientId) {
            this.request.setClientId(clientId);
            return this;
        }

        public Builder withBody(ApiUsageClientQuery body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String clientId, ApiUsageClientQuery body) {
            this.request.setClientId(clientId);
            this.request.setBody(body);
            return this;
        }

        public PostOauthClientUsageQueryRequest build() {
            if (this.request.clientId == null) {
                throw new IllegalStateException("Missing the required parameter 'clientId' when building request for PostOauthClientUsageQueryRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostOauthClientUsageQueryRequest.");
            }
            return this.request;
        }
    }
}

