/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetInfrastructureascodeAcceleratorRequest;
import com.mypurecloud.sdk.v2.api.request.GetInfrastructureascodeAcceleratorsRequest;
import com.mypurecloud.sdk.v2.api.request.GetInfrastructureascodeJobRequest;
import com.mypurecloud.sdk.v2.api.request.GetInfrastructureascodeJobsRequest;
import com.mypurecloud.sdk.v2.api.request.PostInfrastructureascodeJobsRequest;
import com.mypurecloud.sdk.v2.model.AcceleratorInput;
import com.mypurecloud.sdk.v2.model.AcceleratorList;
import com.mypurecloud.sdk.v2.model.AcceleratorSpecification;
import com.mypurecloud.sdk.v2.model.InfrastructureascodeJob;
import java.io.IOException;

public class InfrastructureAsCodeApi {
    private final ApiClient pcapiClient;

    public InfrastructureAsCodeApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InfrastructureAsCodeApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public AcceleratorSpecification getInfrastructureascodeAccelerator(String acceleratorId, String preferredLanguage) throws IOException, ApiException {
        return this.getInfrastructureascodeAccelerator(this.createGetInfrastructureascodeAcceleratorRequest(acceleratorId, preferredLanguage));
    }

    public ApiResponse<AcceleratorSpecification> getInfrastructureascodeAcceleratorWithHttpInfo(String acceleratorId, String preferredLanguage) throws IOException {
        return this.getInfrastructureascodeAccelerator(this.createGetInfrastructureascodeAcceleratorRequest(acceleratorId, preferredLanguage).withHttpInfo());
    }

    private GetInfrastructureascodeAcceleratorRequest createGetInfrastructureascodeAcceleratorRequest(String acceleratorId, String preferredLanguage) {
        return GetInfrastructureascodeAcceleratorRequest.builder().withAcceleratorId(acceleratorId).withPreferredLanguage(preferredLanguage).build();
    }

    public AcceleratorSpecification getInfrastructureascodeAccelerator(GetInfrastructureascodeAcceleratorRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AcceleratorSpecification> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AcceleratorSpecification>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AcceleratorSpecification> getInfrastructureascodeAccelerator(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AcceleratorSpecification>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AcceleratorList getInfrastructureascodeAccelerators(Integer pageSize, Integer pageNumber, String sortBy, String sortOrder, String name, String description, String origin, String type, String classification, String tags) throws IOException, ApiException {
        return this.getInfrastructureascodeAccelerators(this.createGetInfrastructureascodeAcceleratorsRequest(pageSize, pageNumber, sortBy, sortOrder, name, description, origin, type, classification, tags));
    }

    public ApiResponse<AcceleratorList> getInfrastructureascodeAcceleratorsWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, String sortOrder, String name, String description, String origin, String type, String classification, String tags) throws IOException {
        return this.getInfrastructureascodeAccelerators(this.createGetInfrastructureascodeAcceleratorsRequest(pageSize, pageNumber, sortBy, sortOrder, name, description, origin, type, classification, tags).withHttpInfo());
    }

    private GetInfrastructureascodeAcceleratorsRequest createGetInfrastructureascodeAcceleratorsRequest(Integer pageSize, Integer pageNumber, String sortBy, String sortOrder, String name, String description, String origin, String type, String classification, String tags) {
        return GetInfrastructureascodeAcceleratorsRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withSortOrder(sortOrder).withName(name).withDescription(description).withOrigin(origin).withType(type).withClassification(classification).withTags(tags).build();
    }

    public AcceleratorList getInfrastructureascodeAccelerators(GetInfrastructureascodeAcceleratorsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AcceleratorList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AcceleratorList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AcceleratorList> getInfrastructureascodeAccelerators(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AcceleratorList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public InfrastructureascodeJob getInfrastructureascodeJob(String jobId, Boolean details) throws IOException, ApiException {
        return this.getInfrastructureascodeJob(this.createGetInfrastructureascodeJobRequest(jobId, details));
    }

    public ApiResponse<InfrastructureascodeJob> getInfrastructureascodeJobWithHttpInfo(String jobId, Boolean details) throws IOException {
        return this.getInfrastructureascodeJob(this.createGetInfrastructureascodeJobRequest(jobId, details).withHttpInfo());
    }

    private GetInfrastructureascodeJobRequest createGetInfrastructureascodeJobRequest(String jobId, Boolean details) {
        return GetInfrastructureascodeJobRequest.builder().withJobId(jobId).withDetails(details).build();
    }

    public InfrastructureascodeJob getInfrastructureascodeJob(GetInfrastructureascodeJobRequest request) throws IOException, ApiException {
        try {
            ApiResponse<InfrastructureascodeJob> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<InfrastructureascodeJob>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<InfrastructureascodeJob> getInfrastructureascodeJob(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<InfrastructureascodeJob>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public InfrastructureascodeJob getInfrastructureascodeJobs(Integer maxResults, Boolean includeErrors, String sortBy, String sortOrder, String acceleratorId, String submittedBy, String status) throws IOException, ApiException {
        return this.getInfrastructureascodeJobs(this.createGetInfrastructureascodeJobsRequest(maxResults, includeErrors, sortBy, sortOrder, acceleratorId, submittedBy, status));
    }

    public ApiResponse<InfrastructureascodeJob> getInfrastructureascodeJobsWithHttpInfo(Integer maxResults, Boolean includeErrors, String sortBy, String sortOrder, String acceleratorId, String submittedBy, String status) throws IOException {
        return this.getInfrastructureascodeJobs(this.createGetInfrastructureascodeJobsRequest(maxResults, includeErrors, sortBy, sortOrder, acceleratorId, submittedBy, status).withHttpInfo());
    }

    private GetInfrastructureascodeJobsRequest createGetInfrastructureascodeJobsRequest(Integer maxResults, Boolean includeErrors, String sortBy, String sortOrder, String acceleratorId, String submittedBy, String status) {
        return GetInfrastructureascodeJobsRequest.builder().withMaxResults(maxResults).withIncludeErrors(includeErrors).withSortBy(sortBy).withSortOrder(sortOrder).withAcceleratorId(acceleratorId).withSubmittedBy(submittedBy).withStatus(status).build();
    }

    public InfrastructureascodeJob getInfrastructureascodeJobs(GetInfrastructureascodeJobsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<InfrastructureascodeJob> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<InfrastructureascodeJob>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<InfrastructureascodeJob> getInfrastructureascodeJobs(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<InfrastructureascodeJob>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public InfrastructureascodeJob postInfrastructureascodeJobs(AcceleratorInput body) throws IOException, ApiException {
        return this.postInfrastructureascodeJobs(this.createPostInfrastructureascodeJobsRequest(body));
    }

    public ApiResponse<InfrastructureascodeJob> postInfrastructureascodeJobsWithHttpInfo(AcceleratorInput body) throws IOException {
        return this.postInfrastructureascodeJobs(this.createPostInfrastructureascodeJobsRequest(body).withHttpInfo());
    }

    private PostInfrastructureascodeJobsRequest createPostInfrastructureascodeJobsRequest(AcceleratorInput body) {
        return PostInfrastructureascodeJobsRequest.builder().withBody(body).build();
    }

    public InfrastructureascodeJob postInfrastructureascodeJobs(PostInfrastructureascodeJobsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<InfrastructureascodeJob> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<InfrastructureascodeJob>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<InfrastructureascodeJob> postInfrastructureascodeJobs(ApiRequest<AcceleratorInput> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<InfrastructureascodeJob>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

