/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2;

import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;

public class FileWatcher
implements Runnable {
    protected List<FileListener> listeners = new ArrayList<FileListener>();
    protected static final List<WatchService> watchServices = new ArrayList<WatchService>();
    protected final File parentFolder;
    protected Path fileName;

    public FileWatcher(File parentFolder, Path fileName) {
        this.parentFolder = parentFolder;
        this.fileName = fileName;
    }

    public void watch() {
        if (this.parentFolder.exists()) {
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.start();
        }
    }

    @Override
    public void run() {
        try (WatchService watchService = FileSystems.getDefault().newWatchService();){
            Path path = Paths.get(this.parentFolder.getAbsolutePath(), new String[0]);
            path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
            watchServices.add(watchService);
            boolean poll = true;
            while (poll) {
                poll = this.pollEvents(watchService);
            }
        }
        catch (IOException | InterruptedException | ClosedWatchServiceException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected boolean pollEvents(WatchService watchService) throws InterruptedException {
        WatchKey key = watchService.take();
        Path path = (Path)key.watchable();
        for (WatchEvent<?> event : key.pollEvents()) {
            Path changed = (Path)event.context();
            if (!changed.endsWith(this.fileName) && !this.fullPathEndsWith(changed, watchService)) continue;
            this.notifyListeners(event.kind(), path.resolve(changed).toFile());
        }
        return key.reset();
    }

    protected boolean fullPathEndsWith(Path changed, WatchService watchService) {
        boolean nullOrEmpty;
        boolean bl = nullOrEmpty = changed == null || changed.toString().isEmpty() || this.fileName == null || this.fileName.toString().isEmpty();
        if (nullOrEmpty) {
            return false;
        }
        File parentDirectory = new File(this.parentFolder.getAbsolutePath());
        StringBuilder filePath = new StringBuilder();
        filePath = this.fileName.toString().indexOf(92) != -1 ? new StringBuilder(this.fileName.toString().replace('\\', '/')) : new StringBuilder(this.fileName.toString());
        if (filePath.charAt(0) == '/') {
            filePath = new StringBuilder(filePath.substring(1, filePath.length()));
        }
        String[] pathPoints = filePath.toString().split("/");
        return this.searchFiles(parentDirectory, parentDirectory.listFiles(), pathPoints, watchService);
    }

    protected boolean searchFiles(File parent, File[] files, String[] pathPoints, WatchService watchService) {
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (!file.getName().equals(pathPoints[0])) continue;
                if (file.isFile() && file.exists() && file.getAbsolutePath().endsWith(this.fileName.toString())) {
                    return true;
                }
                Path path = Paths.get(file.getAbsolutePath(), new String[0]);
                try {
                    path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.searchFiles(file, file.listFiles(), Arrays.copyOfRange(pathPoints, 1, pathPoints.length), watchService);
            }
        }
        return false;
    }

    protected void notifyListeners(WatchEvent.Kind<?> kind, File file) {
        FileEvent event = new FileEvent(file);
        if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
            ArrayList<FileListener> removeList = new ArrayList<FileListener>();
            for (FileListener listener2 : this.listeners) {
                boolean shouldRemove = listener2.onCreated(event);
                if (!shouldRemove) continue;
                removeList.add(listener2);
            }
            removeList.forEach(listener -> this.removeListener((FileListener)listener));
        } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
            ArrayList<FileListener> removeList = new ArrayList<FileListener>();
            for (FileListener listener3 : this.listeners) {
                boolean shouldRemove = listener3.onModified(event);
                if (!shouldRemove) continue;
                removeList.add(listener3);
            }
            removeList.forEach(listener -> this.removeListener((FileListener)listener));
        }
    }

    public FileWatcher addListener(FileListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public FileWatcher removeListener(FileListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public List<FileListener> getListeners() {
        return this.listeners;
    }

    public FileWatcher setListeners(List<FileListener> listeners) {
        this.listeners = listeners;
        return this;
    }

    public static List<WatchService> getWatchServices() {
        return Collections.unmodifiableList(watchServices);
    }

    public static class FileEvent
    extends EventObject {
        public FileEvent(File file) {
            super(file);
        }

        public File getFile() {
            return (File)this.getSource();
        }
    }

    public static interface FileListener
    extends EventListener {
        public boolean onCreated(FileEvent var1);

        public boolean onModified(FileEvent var1);
    }

    public static abstract class FileAdapter
    implements FileListener {
        @Override
        public boolean onCreated(FileEvent event) {
            return false;
        }

        @Override
        public boolean onModified(FileEvent event) {
            return false;
        }
    }
}

