/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.CoverSheet;
import com.mypurecloud.sdk.v2.model.Workspace;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FaxSendRequest
implements Serializable {
    private String id = null;
    private String name = null;
    private List<String> addresses = new ArrayList<String>();
    private String documentId = null;
    private ContentTypeEnum contentType = null;
    private Workspace workspace = null;
    private CoverSheet coverSheet = null;
    private Integer timeZoneOffsetMinutes = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public FaxSendRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FaxSendRequest addresses(List<String> addresses) {
        this.addresses = addresses;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A list of outbound fax dialing addresses. E.g. +13175555555 or 3175555555")
    @JsonProperty(value="addresses")
    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public FaxSendRequest documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @ApiModelProperty(example="null", value="DocumentId of Content Management artifact. If Content Management document is not used for faxing, documentId should be null")
    @JsonProperty(value="documentId")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public FaxSendRequest contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="null", value="The content type that is going to be uploaded. If Content Management document is used for faxing, contentType will be ignored")
    @JsonProperty(value="contentType")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public FaxSendRequest workspace(Workspace workspace) {
        this.workspace = workspace;
        return this;
    }

    @ApiModelProperty(example="null", value="Workspace in which the document should be stored. If Content Management document is used for faxing, workspace will be ignored")
    @JsonProperty(value="workspace")
    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public FaxSendRequest coverSheet(CoverSheet coverSheet) {
        this.coverSheet = coverSheet;
        return this;
    }

    @ApiModelProperty(example="null", value="Data for coversheet generation.")
    @JsonProperty(value="coverSheet")
    public CoverSheet getCoverSheet() {
        return this.coverSheet;
    }

    public void setCoverSheet(CoverSheet coverSheet) {
        this.coverSheet = coverSheet;
    }

    public FaxSendRequest timeZoneOffsetMinutes(Integer timeZoneOffsetMinutes) {
        this.timeZoneOffsetMinutes = timeZoneOffsetMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Time zone offset minutes from GMT")
    @JsonProperty(value="timeZoneOffsetMinutes")
    public Integer getTimeZoneOffsetMinutes() {
        return this.timeZoneOffsetMinutes;
    }

    public void setTimeZoneOffsetMinutes(Integer timeZoneOffsetMinutes) {
        this.timeZoneOffsetMinutes = timeZoneOffsetMinutes;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaxSendRequest faxSendRequest = (FaxSendRequest)o;
        return Objects.equals(this.id, faxSendRequest.id) && Objects.equals(this.name, faxSendRequest.name) && Objects.equals(this.addresses, faxSendRequest.addresses) && Objects.equals(this.documentId, faxSendRequest.documentId) && Objects.equals((Object)this.contentType, (Object)faxSendRequest.contentType) && Objects.equals(this.workspace, faxSendRequest.workspace) && Objects.equals(this.coverSheet, faxSendRequest.coverSheet) && Objects.equals(this.timeZoneOffsetMinutes, faxSendRequest.timeZoneOffsetMinutes) && Objects.equals(this.selfUri, faxSendRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.addresses, this.documentId, this.contentType, this.workspace, this.coverSheet, this.timeZoneOffsetMinutes, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaxSendRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    workspace: ").append(this.toIndentedString(this.workspace)).append("\n");
        sb.append("    coverSheet: ").append(this.toIndentedString(this.coverSheet)).append("\n");
        sb.append("    timeZoneOffsetMinutes: ").append(this.toIndentedString(this.timeZoneOffsetMinutes)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ContentTypeEnumDeserializer.class)
    public static enum ContentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        APPLICATION_PDF("application/pdf"),
        IMAGE_TIFF("image/tiff"),
        APPLICATION_MSWORD("application/msword"),
        APPLICATION_VND_OASIS_OPENDOCUMENT_TEXT("application/vnd.oasis.opendocument.text"),
        APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT("application/vnd.openxmlformats-officedocument.wordprocessingml.document");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContentTypeEnum value : ContentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ContentTypeEnumDeserializer
    extends StdDeserializer<ContentTypeEnum> {
        public ContentTypeEnumDeserializer() {
            super(ContentTypeEnumDeserializer.class);
        }

        public ContentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ContentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

