/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DocumentText
implements Serializable {
    private String text = null;
    private List<MarksEnum> marks = new ArrayList<MarksEnum>();
    private String hyperlink = null;

    public DocumentText text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Text.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public DocumentText marks(List<MarksEnum> marks) {
        this.marks = marks;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique list of marks (whether it is bold and/or underlined etc.) for the text.")
    @JsonProperty(value="marks")
    public List<MarksEnum> getMarks() {
        return this.marks;
    }

    public void setMarks(List<MarksEnum> marks) {
        this.marks = marks;
    }

    public DocumentText hyperlink(String hyperlink) {
        this.hyperlink = hyperlink;
        return this;
    }

    @ApiModelProperty(example="null", value="The URL of the page that the hyperlink goes to.")
    @JsonProperty(value="hyperlink")
    public String getHyperlink() {
        return this.hyperlink;
    }

    public void setHyperlink(String hyperlink) {
        this.hyperlink = hyperlink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentText documentText = (DocumentText)o;
        return Objects.equals(this.text, documentText.text) && Objects.equals(this.marks, documentText.marks) && Objects.equals(this.hyperlink, documentText.hyperlink);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.marks, this.hyperlink);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentText {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    marks: ").append(this.toIndentedString(this.marks)).append("\n");
        sb.append("    hyperlink: ").append(this.toIndentedString(this.hyperlink)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MarksEnumDeserializer.class)
    public static enum MarksEnum {
        BOLD("Bold"),
        ITALIC("Italic"),
        UNDERLINE("Underline");

        private String value;

        private MarksEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MarksEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MarksEnum value : MarksEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MarksEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MarksEnumDeserializer
    extends StdDeserializer<MarksEnum> {
        public MarksEnumDeserializer() {
            super(MarksEnumDeserializer.class);
        }

        public MarksEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MarksEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

