/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Detail;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Operation
implements Serializable {
    private String id = null;
    private Boolean complete = null;
    private User user = null;
    private DomainEntityRef client = null;
    private String errorMessage = null;
    private String errorCode = null;
    private List<Detail> errorDetails = new ArrayList<Detail>();
    private Map<String, String> errorMessageParams = null;
    private ActionNameEnum actionName = null;
    private ActionStatusEnum actionStatus = null;

    public Operation id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Operation complete(Boolean complete) {
        this.complete = complete;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="complete")
    public Boolean getComplete() {
        return this.complete;
    }

    public void setComplete(Boolean complete) {
        this.complete = complete;
    }

    public Operation user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="user")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Operation client(DomainEntityRef client) {
        this.client = client;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="client")
    public DomainEntityRef getClient() {
        return this.client;
    }

    public void setClient(DomainEntityRef client) {
        this.client = client;
    }

    public Operation errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Operation errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="errorCode")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Operation errorDetails(List<Detail> errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="errorDetails")
    public List<Detail> getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(List<Detail> errorDetails) {
        this.errorDetails = errorDetails;
    }

    public Operation errorMessageParams(Map<String, String> errorMessageParams) {
        this.errorMessageParams = errorMessageParams;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="errorMessageParams")
    public Map<String, String> getErrorMessageParams() {
        return this.errorMessageParams;
    }

    public void setErrorMessageParams(Map<String, String> errorMessageParams) {
        this.errorMessageParams = errorMessageParams;
    }

    public Operation actionName(ActionNameEnum actionName) {
        this.actionName = actionName;
        return this;
    }

    @ApiModelProperty(example="null", value="Action name")
    @JsonProperty(value="actionName")
    public ActionNameEnum getActionName() {
        return this.actionName;
    }

    public void setActionName(ActionNameEnum actionName) {
        this.actionName = actionName;
    }

    public Operation actionStatus(ActionStatusEnum actionStatus) {
        this.actionStatus = actionStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Action status")
    @JsonProperty(value="actionStatus")
    public ActionStatusEnum getActionStatus() {
        return this.actionStatus;
    }

    public void setActionStatus(ActionStatusEnum actionStatus) {
        this.actionStatus = actionStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Operation operation = (Operation)o;
        return Objects.equals(this.id, operation.id) && Objects.equals(this.complete, operation.complete) && Objects.equals(this.user, operation.user) && Objects.equals(this.client, operation.client) && Objects.equals(this.errorMessage, operation.errorMessage) && Objects.equals(this.errorCode, operation.errorCode) && Objects.equals(this.errorDetails, operation.errorDetails) && Objects.equals(this.errorMessageParams, operation.errorMessageParams) && Objects.equals((Object)this.actionName, (Object)operation.actionName) && Objects.equals((Object)this.actionStatus, (Object)operation.actionStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.complete, this.user, this.client, this.errorMessage, this.errorCode, this.errorDetails, this.errorMessageParams, this.actionName, this.actionStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Operation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    complete: ").append(this.toIndentedString(this.complete)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    client: ").append(this.toIndentedString(this.client)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    errorMessageParams: ").append(this.toIndentedString(this.errorMessageParams)).append("\n");
        sb.append("    actionName: ").append(this.toIndentedString((Object)this.actionName)).append("\n");
        sb.append("    actionStatus: ").append(this.toIndentedString((Object)this.actionStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActionStatusEnumDeserializer.class)
    public static enum ActionStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        LOCKED("LOCKED"),
        UNLOCKED("UNLOCKED"),
        STARTED("STARTED"),
        PENDING_GENERATION("PENDING_GENERATION"),
        PENDING_BACKEND_NOTIFICATION("PENDING_BACKEND_NOTIFICATION"),
        SUCCESS("SUCCESS"),
        FAILURE("FAILURE");

        private String value;

        private ActionStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionStatusEnum value : ActionStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionStatusEnumDeserializer
    extends StdDeserializer<ActionStatusEnum> {
        public ActionStatusEnumDeserializer() {
            super(ActionStatusEnumDeserializer.class);
        }

        public ActionStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=ActionNameEnumDeserializer.class)
    public static enum ActionNameEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CREATE("CREATE"),
        CHECKIN("CHECKIN"),
        CHECKOUT("CHECKOUT"),
        DEBUG("DEBUG"),
        DELETE("DELETE"),
        HISTORY("HISTORY"),
        PUBLISH("PUBLISH"),
        REVERT("REVERT"),
        SAVE("SAVE"),
        STATE_CHANGE("STATE_CHANGE"),
        UPDATE("UPDATE"),
        VALIDATE("VALIDATE");

        private String value;

        private ActionNameEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionNameEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionNameEnum value : ActionNameEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionNameEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionNameEnumDeserializer
    extends StdDeserializer<ActionNameEnum> {
        public ActionNameEnumDeserializer() {
            super(ActionNameEnumDeserializer.class);
        }

        public ActionNameEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionNameEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

