/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.KnowledgeDocumentSearchResult;
import com.mypurecloud.sdk.v2.model.KnowledgeSearchClientApplication;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class KnowledgeDocumentSearch
implements Serializable {
    private String query = null;
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private String searchId = null;
    private Integer total = null;
    private Integer pageCount = null;
    private List<KnowledgeDocumentSearchResult> results = new ArrayList<KnowledgeDocumentSearchResult>();
    private KnowledgeSearchClientApplication application = null;

    public KnowledgeDocumentSearch query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Query to search content in the knowledge base. Maximum of 30 records per query can be fetched.")
    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public KnowledgeDocumentSearch pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="Page size of the returned results.")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public KnowledgeDocumentSearch pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Page number of the returned results.")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the search.")
    @JsonProperty(value="searchId")
    public String getSearchId() {
        return this.searchId;
    }

    @ApiModelProperty(example="null", value="The total number of documents matching the query.")
    @JsonProperty(value="total")
    public Integer getTotal() {
        return this.total;
    }

    @ApiModelProperty(example="null", value="Number of pages returned in the result calculated according to the pageSize and the total")
    @JsonProperty(value="pageCount")
    public Integer getPageCount() {
        return this.pageCount;
    }

    @ApiModelProperty(example="null", value="Documents matching the search query.")
    @JsonProperty(value="results")
    public List<KnowledgeDocumentSearchResult> getResults() {
        return this.results;
    }

    public KnowledgeDocumentSearch application(KnowledgeSearchClientApplication application) {
        this.application = application;
        return this;
    }

    @ApiModelProperty(example="null", value="The client application details from which search happened.")
    @JsonProperty(value="application")
    public KnowledgeSearchClientApplication getApplication() {
        return this.application;
    }

    public void setApplication(KnowledgeSearchClientApplication application) {
        this.application = application;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeDocumentSearch knowledgeDocumentSearch = (KnowledgeDocumentSearch)o;
        return Objects.equals(this.query, knowledgeDocumentSearch.query) && Objects.equals(this.pageSize, knowledgeDocumentSearch.pageSize) && Objects.equals(this.pageNumber, knowledgeDocumentSearch.pageNumber) && Objects.equals(this.searchId, knowledgeDocumentSearch.searchId) && Objects.equals(this.total, knowledgeDocumentSearch.total) && Objects.equals(this.pageCount, knowledgeDocumentSearch.pageCount) && Objects.equals(this.results, knowledgeDocumentSearch.results) && Objects.equals(this.application, knowledgeDocumentSearch.application);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.pageSize, this.pageNumber, this.searchId, this.total, this.pageCount, this.results, this.application);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeDocumentSearch {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    searchId: ").append(this.toIndentedString(this.searchId)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

