/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.NluDomainVersion;
import java.util.HashMap;
import java.util.Map;

public class PutLanguageunderstandingDomainVersionRequest {
    private String domainId;
    private String domainVersionId;
    private NluDomainVersion body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public PutLanguageunderstandingDomainVersionRequest withDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public String getDomainVersionId() {
        return this.domainVersionId;
    }

    public void setDomainVersionId(String domainVersionId) {
        this.domainVersionId = domainVersionId;
    }

    public PutLanguageunderstandingDomainVersionRequest withDomainVersionId(String domainVersionId) {
        this.setDomainVersionId(domainVersionId);
        return this;
    }

    public NluDomainVersion getBody() {
        return this.body;
    }

    public void setBody(NluDomainVersion body) {
        this.body = body;
    }

    public PutLanguageunderstandingDomainVersionRequest withBody(NluDomainVersion body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutLanguageunderstandingDomainVersionRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<NluDomainVersion> withHttpInfo() {
        if (this.domainId == null) {
            throw new IllegalStateException("Missing the required parameter 'domainId' when building request for PutLanguageunderstandingDomainVersionRequest.");
        }
        if (this.domainVersionId == null) {
            throw new IllegalStateException("Missing the required parameter 'domainVersionId' when building request for PutLanguageunderstandingDomainVersionRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutLanguageunderstandingDomainVersionRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}").withPathParameter("domainId", this.domainId).withPathParameter("domainVersionId", this.domainVersionId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String domainId, String domainVersionId, NluDomainVersion body) {
        return new Builder().withRequiredParams(domainId, domainVersionId, body);
    }

    public static class Builder {
        private final PutLanguageunderstandingDomainVersionRequest request = new PutLanguageunderstandingDomainVersionRequest();

        private Builder() {
        }

        public Builder withDomainId(String domainId) {
            this.request.setDomainId(domainId);
            return this;
        }

        public Builder withDomainVersionId(String domainVersionId) {
            this.request.setDomainVersionId(domainVersionId);
            return this;
        }

        public Builder withBody(NluDomainVersion body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String domainId, String domainVersionId, NluDomainVersion body) {
            this.request.setDomainId(domainId);
            this.request.setDomainVersionId(domainVersionId);
            this.request.setBody(body);
            return this;
        }

        public PutLanguageunderstandingDomainVersionRequest build() {
            if (this.request.domainId == null) {
                throw new IllegalStateException("Missing the required parameter 'domainId' when building request for PutLanguageunderstandingDomainVersionRequest.");
            }
            if (this.request.domainVersionId == null) {
                throw new IllegalStateException("Missing the required parameter 'domainVersionId' when building request for PutLanguageunderstandingDomainVersionRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutLanguageunderstandingDomainVersionRequest.");
            }
            return this.request;
        }
    }
}

