/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class UploadUrlRequest
implements Serializable {
    private String fileName = null;
    private String contentMd5 = null;
    private Integer signedUrlTimeoutSeconds = null;
    private String contentType = null;
    private ServerSideEncryptionEnum serverSideEncryption = null;

    public UploadUrlRequest fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the file to upload. It must not start with a dot and not end with a forward slash. Whitespace and the following characters are not allowed: \\{^}%`]\">[~<#|")
    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public UploadUrlRequest contentMd5(String contentMd5) {
        this.contentMd5 = contentMd5;
        return this;
    }

    @ApiModelProperty(example="null", value="Content MD5 of the file to upload")
    @JsonProperty(value="contentMd5")
    public String getContentMd5() {
        return this.contentMd5;
    }

    public void setContentMd5(String contentMd5) {
        this.contentMd5 = contentMd5;
    }

    public UploadUrlRequest signedUrlTimeoutSeconds(Integer signedUrlTimeoutSeconds) {
        this.signedUrlTimeoutSeconds = signedUrlTimeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of seconds the presigned URL is valid for (from 1 to 604800 seconds). If none provided, defaults to 600 seconds")
    @JsonProperty(value="signedUrlTimeoutSeconds")
    public Integer getSignedUrlTimeoutSeconds() {
        return this.signedUrlTimeoutSeconds;
    }

    public void setSignedUrlTimeoutSeconds(Integer signedUrlTimeoutSeconds) {
        this.signedUrlTimeoutSeconds = signedUrlTimeoutSeconds;
    }

    public UploadUrlRequest contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="null", value="The content type of the file to upload. Allows all MIME types")
    @JsonProperty(value="contentType")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public UploadUrlRequest serverSideEncryption(ServerSideEncryptionEnum serverSideEncryption) {
        this.serverSideEncryption = serverSideEncryption;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="serverSideEncryption")
    public ServerSideEncryptionEnum getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public void setServerSideEncryption(ServerSideEncryptionEnum serverSideEncryption) {
        this.serverSideEncryption = serverSideEncryption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadUrlRequest uploadUrlRequest = (UploadUrlRequest)o;
        return Objects.equals(this.fileName, uploadUrlRequest.fileName) && Objects.equals(this.contentMd5, uploadUrlRequest.contentMd5) && Objects.equals(this.signedUrlTimeoutSeconds, uploadUrlRequest.signedUrlTimeoutSeconds) && Objects.equals(this.contentType, uploadUrlRequest.contentType) && Objects.equals((Object)this.serverSideEncryption, (Object)uploadUrlRequest.serverSideEncryption);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileName, this.contentMd5, this.signedUrlTimeoutSeconds, this.contentType, this.serverSideEncryption});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UploadUrlRequest {\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    contentMd5: ").append(this.toIndentedString(this.contentMd5)).append("\n");
        sb.append("    signedUrlTimeoutSeconds: ").append(this.toIndentedString(this.signedUrlTimeoutSeconds)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    serverSideEncryption: ").append(this.toIndentedString((Object)this.serverSideEncryption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ServerSideEncryptionEnumDeserializer.class)
    public static enum ServerSideEncryptionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AES256("AES256");

        private String value;

        private ServerSideEncryptionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ServerSideEncryptionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ServerSideEncryptionEnum value : ServerSideEncryptionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ServerSideEncryptionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ServerSideEncryptionEnumDeserializer
    extends StdDeserializer<ServerSideEncryptionEnum> {
        public ServerSideEncryptionEnumDeserializer() {
            super(ServerSideEncryptionEnumDeserializer.class);
        }

        public ServerSideEncryptionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ServerSideEncryptionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

