/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApiUsageQuery
implements Serializable {
    private String interval = null;
    private GranularityEnum granularity = null;
    private List<GroupByEnum> groupBy = new ArrayList<GroupByEnum>();
    private List<MetricsEnum> metrics = new ArrayList<MetricsEnum>();

    public ApiUsageQuery interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public ApiUsageQuery granularity(GranularityEnum granularity) {
        this.granularity = granularity;
        return this;
    }

    @ApiModelProperty(example="null", value="Date granularity of the results")
    @JsonProperty(value="granularity")
    public GranularityEnum getGranularity() {
        return this.granularity;
    }

    public void setGranularity(GranularityEnum granularity) {
        this.granularity = granularity;
    }

    public ApiUsageQuery groupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL GROUPBY. Allows for multiple levels of grouping as a list of dimensions. Partitions resulting aggregate computations into distinct named subgroups rather than across the entire result set as if it were one group.")
    @JsonProperty(value="groupBy")
    public List<GroupByEnum> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
    }

    public ApiUsageQuery metrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL SELECT clause. Enables retrieving only named metrics. If omitted, all metrics that are available will be returned (like SELECT *).")
    @JsonProperty(value="metrics")
    public List<MetricsEnum> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiUsageQuery apiUsageQuery = (ApiUsageQuery)o;
        return Objects.equals(this.interval, apiUsageQuery.interval) && Objects.equals((Object)this.granularity, (Object)apiUsageQuery.granularity) && Objects.equals(this.groupBy, apiUsageQuery.groupBy) && Objects.equals(this.metrics, apiUsageQuery.metrics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.granularity, this.groupBy, this.metrics});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiUsageQuery {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MetricsEnumDeserializer.class)
    public static enum MetricsEnum {
        STATUS200("Status200"),
        STATUS300("Status300"),
        STATUS400("Status400"),
        STATUS500("Status500"),
        STATUS429("Status429"),
        REQUESTS("Requests");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricsEnum value : MetricsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MetricsEnumDeserializer
    extends StdDeserializer<MetricsEnum> {
        public MetricsEnumDeserializer() {
            super(MetricsEnumDeserializer.class);
        }

        public MetricsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=GroupByEnumDeserializer.class)
    public static enum GroupByEnum {
        OAUTHCLIENTID("OAuthClientId"),
        ORGANIZATIONID("OrganizationId"),
        USERID("UserId"),
        TEMPLATEURI("TemplateUri"),
        HTTPMETHOD("HttpMethod");

        private String value;

        private GroupByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GroupByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GroupByEnum value : GroupByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GroupByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GroupByEnumDeserializer
    extends StdDeserializer<GroupByEnum> {
        public GroupByEnumDeserializer() {
            super(GroupByEnumDeserializer.class);
        }

        public GroupByEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GroupByEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=GranularityEnumDeserializer.class)
    public static enum GranularityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAY("Day"),
        WEEK("Week"),
        MONTH("Month");

        private String value;

        private GranularityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GranularityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GranularityEnum value : GranularityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GranularityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GranularityEnumDeserializer
    extends StdDeserializer<GranularityEnum> {
        public GranularityEnumDeserializer() {
            super(GranularityEnumDeserializer.class);
        }

        public GranularityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GranularityEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

