/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.InitialConfiguration;
import com.mypurecloud.sdk.v2.model.SourceConfiguration;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class RoutingEstablishedEvent
implements Serializable {
    private String eventId = null;
    private Date eventDateTime = null;
    private String conversationId = null;
    private String communicationId = null;
    private String phoneNumber = null;
    private String queueId = null;
    private List<String> skillIds = new ArrayList<String>();
    private String languageId = null;
    private InitialConfiguration initialConfiguration = null;
    private SourceConfiguration sourceConfiguration = null;

    public RoutingEstablishedEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique (V4 UUID) eventId for this event")
    @JsonProperty(value="eventId")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public RoutingEstablishedEvent eventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A Date Time representing the time this event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="eventDateTime")
    public Date getEventDateTime() {
        return this.eventDateTime;
    }

    public void setEventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
    }

    public RoutingEstablishedEvent conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique Id (V4 UUID) identifying this conversation")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public RoutingEstablishedEvent communicationId(String communicationId) {
        this.communicationId = communicationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique Id (V4 UUID) identifying this communication")
    @JsonProperty(value="communicationId")
    public String getCommunicationId() {
        return this.communicationId;
    }

    public void setCommunicationId(String communicationId) {
        this.communicationId = communicationId;
    }

    public RoutingEstablishedEvent phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifies the phone number used to reach this queue if it is different from the information that would be accessed by queueId.")
    @JsonProperty(value="phoneNumber")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public RoutingEstablishedEvent queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id (V4 UUID) of the queue that is routing this conversation.")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public RoutingEstablishedEvent skillIds(List<String> skillIds) {
        this.skillIds = skillIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique identifiers (V4 UUID) for the skills that should be used to determine the destination for the conversation.")
    @JsonProperty(value="skillIds")
    public List<String> getSkillIds() {
        return this.skillIds;
    }

    public void setSkillIds(List<String> skillIds) {
        this.skillIds = skillIds;
    }

    public RoutingEstablishedEvent languageId(String languageId) {
        this.languageId = languageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique identifier (V4 UUID) for the language that should be used to determine the destination for the conversation.")
    @JsonProperty(value="languageId")
    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String languageId) {
        this.languageId = languageId;
    }

    public RoutingEstablishedEvent initialConfiguration(InitialConfiguration initialConfiguration) {
        this.initialConfiguration = initialConfiguration;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Metadata about this communication.")
    @JsonProperty(value="initialConfiguration")
    public InitialConfiguration getInitialConfiguration() {
        return this.initialConfiguration;
    }

    public void setInitialConfiguration(InitialConfiguration initialConfiguration) {
        this.initialConfiguration = initialConfiguration;
    }

    public RoutingEstablishedEvent sourceConfiguration(SourceConfiguration sourceConfiguration) {
        this.sourceConfiguration = sourceConfiguration;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Metadata about the source of this communication's interaction.")
    @JsonProperty(value="sourceConfiguration")
    public SourceConfiguration getSourceConfiguration() {
        return this.sourceConfiguration;
    }

    public void setSourceConfiguration(SourceConfiguration sourceConfiguration) {
        this.sourceConfiguration = sourceConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingEstablishedEvent routingEstablishedEvent = (RoutingEstablishedEvent)o;
        return Objects.equals(this.eventId, routingEstablishedEvent.eventId) && Objects.equals(this.eventDateTime, routingEstablishedEvent.eventDateTime) && Objects.equals(this.conversationId, routingEstablishedEvent.conversationId) && Objects.equals(this.communicationId, routingEstablishedEvent.communicationId) && Objects.equals(this.phoneNumber, routingEstablishedEvent.phoneNumber) && Objects.equals(this.queueId, routingEstablishedEvent.queueId) && Objects.equals(this.skillIds, routingEstablishedEvent.skillIds) && Objects.equals(this.languageId, routingEstablishedEvent.languageId) && Objects.equals(this.initialConfiguration, routingEstablishedEvent.initialConfiguration) && Objects.equals(this.sourceConfiguration, routingEstablishedEvent.sourceConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.eventDateTime, this.conversationId, this.communicationId, this.phoneNumber, this.queueId, this.skillIds, this.languageId, this.initialConfiguration, this.sourceConfiguration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoutingEstablishedEvent {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventDateTime: ").append(this.toIndentedString(this.eventDateTime)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    communicationId: ").append(this.toIndentedString(this.communicationId)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    skillIds: ").append(this.toIndentedString(this.skillIds)).append("\n");
        sb.append("    languageId: ").append(this.toIndentedString(this.languageId)).append("\n");
        sb.append("    initialConfiguration: ").append(this.toIndentedString(this.initialConfiguration)).append("\n");
        sb.append("    sourceConfiguration: ").append(this.toIndentedString(this.sourceConfiguration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

