/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class InteractionStatsAlert
implements Serializable {
    private String id = null;
    private String name = null;
    private DimensionEnum dimension = null;
    private String dimensionValue = null;
    private MetricEnum metric = null;
    private MediaTypeEnum mediaType = null;
    private NumericRangeEnum numericRange = null;
    private StatisticEnum statistic = null;
    private Double value = null;
    private String ruleId = null;
    private Boolean unread = null;
    private Date startDate = null;
    private Date endDate = null;
    private List<User> notificationUsers = new ArrayList<User>();
    private List<AlertTypesEnum> alertTypes = new ArrayList<AlertTypesEnum>();
    private String ruleUri = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the rule that generated the alert")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", required=true, value="The dimension of concern.")
    @JsonProperty(value="dimension")
    public DimensionEnum getDimension() {
        return this.dimension;
    }

    @ApiModelProperty(example="null", required=true, value="The value of the dimension.")
    @JsonProperty(value="dimensionValue")
    public String getDimensionValue() {
        return this.dimensionValue;
    }

    @ApiModelProperty(example="null", required=true, value="The metric to be assessed.")
    @JsonProperty(value="metric")
    public MetricEnum getMetric() {
        return this.metric;
    }

    @ApiModelProperty(example="null", required=true, value="The media type.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    @ApiModelProperty(example="null", required=true, value="The comparison descriptor used against the metric's value.")
    @JsonProperty(value="numericRange")
    public NumericRangeEnum getNumericRange() {
        return this.numericRange;
    }

    @ApiModelProperty(example="null", required=true, value="The statistic of concern for the metric.")
    @JsonProperty(value="statistic")
    public StatisticEnum getStatistic() {
        return this.statistic;
    }

    @ApiModelProperty(example="null", required=true, value="The threshold value.")
    @JsonProperty(value="value")
    public Double getValue() {
        return this.value;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the rule.")
    @JsonProperty(value="ruleId")
    public String getRuleId() {
        return this.ruleId;
    }

    public InteractionStatsAlert unread(Boolean unread) {
        this.unread = unread;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates if the alert has been read.")
    @JsonProperty(value="unread")
    public Boolean getUnread() {
        return this.unread;
    }

    public void setUnread(Boolean unread) {
        this.unread = unread;
    }

    @ApiModelProperty(example="null", required=true, value="The date/time the alert was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    @ApiModelProperty(example="null", value="The date/time the owning rule exiting in alarm status. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    @ApiModelProperty(example="null", required=true, value="The ids of users who were notified of alarm state change.")
    @JsonProperty(value="notificationUsers")
    public List<User> getNotificationUsers() {
        return this.notificationUsers;
    }

    @ApiModelProperty(example="null", required=true, value="A collection of notification methods.")
    @JsonProperty(value="alertTypes")
    public List<AlertTypesEnum> getAlertTypes() {
        return this.alertTypes;
    }

    public InteractionStatsAlert ruleUri(String ruleUri) {
        this.ruleUri = ruleUri;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="ruleUri")
    public String getRuleUri() {
        return this.ruleUri;
    }

    public void setRuleUri(String ruleUri) {
        this.ruleUri = ruleUri;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InteractionStatsAlert interactionStatsAlert = (InteractionStatsAlert)o;
        return Objects.equals(this.id, interactionStatsAlert.id) && Objects.equals(this.name, interactionStatsAlert.name) && Objects.equals((Object)this.dimension, (Object)interactionStatsAlert.dimension) && Objects.equals(this.dimensionValue, interactionStatsAlert.dimensionValue) && Objects.equals((Object)this.metric, (Object)interactionStatsAlert.metric) && Objects.equals((Object)this.mediaType, (Object)interactionStatsAlert.mediaType) && Objects.equals((Object)this.numericRange, (Object)interactionStatsAlert.numericRange) && Objects.equals((Object)this.statistic, (Object)interactionStatsAlert.statistic) && Objects.equals(this.value, interactionStatsAlert.value) && Objects.equals(this.ruleId, interactionStatsAlert.ruleId) && Objects.equals(this.unread, interactionStatsAlert.unread) && Objects.equals(this.startDate, interactionStatsAlert.startDate) && Objects.equals(this.endDate, interactionStatsAlert.endDate) && Objects.equals(this.notificationUsers, interactionStatsAlert.notificationUsers) && Objects.equals(this.alertTypes, interactionStatsAlert.alertTypes) && Objects.equals(this.ruleUri, interactionStatsAlert.ruleUri) && Objects.equals(this.selfUri, interactionStatsAlert.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.dimension, this.dimensionValue, this.metric, this.mediaType, this.numericRange, this.statistic, this.value, this.ruleId, this.unread, this.startDate, this.endDate, this.notificationUsers, this.alertTypes, this.ruleUri, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InteractionStatsAlert {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dimension: ").append(this.toIndentedString((Object)this.dimension)).append("\n");
        sb.append("    dimensionValue: ").append(this.toIndentedString(this.dimensionValue)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString((Object)this.metric)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    numericRange: ").append(this.toIndentedString((Object)this.numericRange)).append("\n");
        sb.append("    statistic: ").append(this.toIndentedString((Object)this.statistic)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    ruleId: ").append(this.toIndentedString(this.ruleId)).append("\n");
        sb.append("    unread: ").append(this.toIndentedString(this.unread)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    notificationUsers: ").append(this.toIndentedString(this.notificationUsers)).append("\n");
        sb.append("    alertTypes: ").append(this.toIndentedString(this.alertTypes)).append("\n");
        sb.append("    ruleUri: ").append(this.toIndentedString(this.ruleUri)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AlertTypesEnumDeserializer.class)
    public static enum AlertTypesEnum {
        SMS("SMS"),
        DEVICE("DEVICE"),
        EMAIL("EMAIL");

        private String value;

        private AlertTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AlertTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AlertTypesEnum value : AlertTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AlertTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AlertTypesEnumDeserializer
    extends StdDeserializer<AlertTypesEnum> {
        public AlertTypesEnumDeserializer() {
            super(AlertTypesEnumDeserializer.class);
        }

        public AlertTypesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AlertTypesEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=StatisticEnumDeserializer.class)
    public static enum StatisticEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COUNT("count"),
        MIN("min"),
        RATIO("ratio"),
        MAX("max");

        private String value;

        private StatisticEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatisticEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatisticEnum value : StatisticEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatisticEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatisticEnumDeserializer
    extends StdDeserializer<StatisticEnum> {
        public StatisticEnumDeserializer() {
            super(StatisticEnumDeserializer.class);
        }

        public StatisticEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatisticEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=NumericRangeEnumDeserializer.class)
    public static enum NumericRangeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GT("gt"),
        GTE("gte"),
        LT("lt"),
        LTE("lte"),
        EQ("eq"),
        NE("ne");

        private String value;

        private NumericRangeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static NumericRangeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (NumericRangeEnum value : NumericRangeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return NumericRangeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class NumericRangeEnumDeserializer
    extends StdDeserializer<NumericRangeEnum> {
        public NumericRangeEnumDeserializer() {
            super(NumericRangeEnumDeserializer.class);
        }

        public NumericRangeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return NumericRangeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VOICE("voice"),
        CHAT("chat"),
        EMAIL("email"),
        CALLBACK("callback"),
        MESSAGE("message");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MetricEnumDeserializer.class)
    public static enum MetricEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TABANDON("tAbandon"),
        TANSWERED("tAnswered"),
        TTALK("tTalk"),
        NOFFERED("nOffered"),
        THANDLE("tHandle"),
        NTRANSFERRED("nTransferred"),
        OSERVICELEVEL("oServiceLevel"),
        TWAIT("tWait"),
        THELD("tHeld"),
        TACW("tAcw");

        private String value;

        private MetricEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricEnum value : MetricEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MetricEnumDeserializer
    extends StdDeserializer<MetricEnum> {
        public MetricEnumDeserializer() {
            super(MetricEnumDeserializer.class);
        }

        public MetricEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=DimensionEnumDeserializer.class)
    public static enum DimensionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUEUEID("queueId"),
        USERID("userId");

        private String value;

        private DimensionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DimensionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DimensionEnum value : DimensionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DimensionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DimensionEnumDeserializer
    extends StdDeserializer<DimensionEnum> {
        public DimensionEnumDeserializer() {
            super(DimensionEnumDeserializer.class);
        }

        public DimensionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DimensionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

