/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="A CoBrowse event.")
public class EventCoBrowse
implements Serializable {
    private TypeEnum type = null;
    private String sessionId = null;
    private String sessionJoinToken = null;

    public EventCoBrowse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Describes the type of CoBrowse event.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public EventCoBrowse sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The CoBrowse session ID.")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public EventCoBrowse sessionJoinToken(String sessionJoinToken) {
        this.sessionJoinToken = sessionJoinToken;
        return this;
    }

    @ApiModelProperty(example="null", value="The CoBrowse session join token.")
    @JsonProperty(value="sessionJoinToken")
    public String getSessionJoinToken() {
        return this.sessionJoinToken;
    }

    public void setSessionJoinToken(String sessionJoinToken) {
        this.sessionJoinToken = sessionJoinToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventCoBrowse eventCoBrowse = (EventCoBrowse)o;
        return Objects.equals((Object)this.type, (Object)eventCoBrowse.type) && Objects.equals(this.sessionId, eventCoBrowse.sessionId) && Objects.equals(this.sessionJoinToken, eventCoBrowse.sessionJoinToken);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.sessionId, this.sessionJoinToken});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventCoBrowse {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    sessionJoinToken: ").append(this.toIndentedString(this.sessionJoinToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OFFERING("Offering"),
        OFFERINGEXPIRED("OfferingExpired"),
        OFFERINGACCEPTED("OfferingAccepted"),
        OFFERINGREJECTED("OfferingRejected");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

