/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Settings concerning cobrowse")
public class CobrowseSettings
implements Serializable {
    private Boolean enabled = null;
    private Boolean allowAgentControl = null;
    private List<String> maskSelectors = new ArrayList<String>();

    public CobrowseSettings enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not cobrowse is enabled")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public CobrowseSettings allowAgentControl(Boolean allowAgentControl) {
        this.allowAgentControl = allowAgentControl;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the viewer should have option to request control")
    @JsonProperty(value="allowAgentControl")
    public Boolean getAllowAgentControl() {
        return this.allowAgentControl;
    }

    public void setAllowAgentControl(Boolean allowAgentControl) {
        this.allowAgentControl = allowAgentControl;
    }

    public CobrowseSettings maskSelectors(List<String> maskSelectors) {
        this.maskSelectors = maskSelectors;
        return this;
    }

    @ApiModelProperty(example="null", value="Mask patterns that will apply to pages being shared")
    @JsonProperty(value="maskSelectors")
    public List<String> getMaskSelectors() {
        return this.maskSelectors;
    }

    public void setMaskSelectors(List<String> maskSelectors) {
        this.maskSelectors = maskSelectors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CobrowseSettings cobrowseSettings = (CobrowseSettings)o;
        return Objects.equals(this.enabled, cobrowseSettings.enabled) && Objects.equals(this.allowAgentControl, cobrowseSettings.allowAgentControl) && Objects.equals(this.maskSelectors, cobrowseSettings.maskSelectors);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.allowAgentControl, this.maskSelectors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CobrowseSettings {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    allowAgentControl: ").append(this.toIndentedString(this.allowAgentControl)).append("\n");
        sb.append("    maskSelectors: ").append(this.toIndentedString(this.maskSelectors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

