/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AnalyticsSession;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AnalyticsParticipantWithoutAttributes
implements Serializable {
    private String externalContactId = null;
    private String externalOrganizationId = null;
    private FlaggedReasonEnum flaggedReason = null;
    private String participantId = null;
    private String participantName = null;
    private PurposeEnum purpose = null;
    private String teamId = null;
    private String userId = null;
    private List<AnalyticsSession> sessions = new ArrayList<AnalyticsSession>();

    public AnalyticsParticipantWithoutAttributes externalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
        return this;
    }

    @ApiModelProperty(example="null", value="External contact identifier")
    @JsonProperty(value="externalContactId")
    public String getExternalContactId() {
        return this.externalContactId;
    }

    public void setExternalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
    }

    public AnalyticsParticipantWithoutAttributes externalOrganizationId(String externalOrganizationId) {
        this.externalOrganizationId = externalOrganizationId;
        return this;
    }

    @ApiModelProperty(example="null", value="External organization identifier")
    @JsonProperty(value="externalOrganizationId")
    public String getExternalOrganizationId() {
        return this.externalOrganizationId;
    }

    public void setExternalOrganizationId(String externalOrganizationId) {
        this.externalOrganizationId = externalOrganizationId;
    }

    public AnalyticsParticipantWithoutAttributes flaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
        return this;
    }

    @ApiModelProperty(example="null", value="Reason for which participant flagged conversation")
    @JsonProperty(value="flaggedReason")
    public FlaggedReasonEnum getFlaggedReason() {
        return this.flaggedReason;
    }

    public void setFlaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
    }

    public AnalyticsParticipantWithoutAttributes participantId(String participantId) {
        this.participantId = participantId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the participant")
    @JsonProperty(value="participantId")
    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public AnalyticsParticipantWithoutAttributes participantName(String participantName) {
        this.participantName = participantName;
        return this;
    }

    @ApiModelProperty(example="null", value="A human readable name identifying the participant")
    @JsonProperty(value="participantName")
    public String getParticipantName() {
        return this.participantName;
    }

    public void setParticipantName(String participantName) {
        this.participantName = participantName;
    }

    public AnalyticsParticipantWithoutAttributes purpose(PurposeEnum purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's purpose")
    @JsonProperty(value="purpose")
    public PurposeEnum getPurpose() {
        return this.purpose;
    }

    public void setPurpose(PurposeEnum purpose) {
        this.purpose = purpose;
    }

    public AnalyticsParticipantWithoutAttributes teamId(String teamId) {
        this.teamId = teamId;
        return this;
    }

    @ApiModelProperty(example="null", value="The team ID the user is a member of")
    @JsonProperty(value="teamId")
    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public AnalyticsParticipantWithoutAttributes userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the user")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public AnalyticsParticipantWithoutAttributes sessions(List<AnalyticsSession> sessions) {
        this.sessions = sessions;
        return this;
    }

    @ApiModelProperty(example="null", value="List of sessions associated to this participant")
    @JsonProperty(value="sessions")
    public List<AnalyticsSession> getSessions() {
        return this.sessions;
    }

    public void setSessions(List<AnalyticsSession> sessions) {
        this.sessions = sessions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsParticipantWithoutAttributes analyticsParticipantWithoutAttributes = (AnalyticsParticipantWithoutAttributes)o;
        return Objects.equals(this.externalContactId, analyticsParticipantWithoutAttributes.externalContactId) && Objects.equals(this.externalOrganizationId, analyticsParticipantWithoutAttributes.externalOrganizationId) && Objects.equals((Object)this.flaggedReason, (Object)analyticsParticipantWithoutAttributes.flaggedReason) && Objects.equals(this.participantId, analyticsParticipantWithoutAttributes.participantId) && Objects.equals(this.participantName, analyticsParticipantWithoutAttributes.participantName) && Objects.equals((Object)this.purpose, (Object)analyticsParticipantWithoutAttributes.purpose) && Objects.equals(this.teamId, analyticsParticipantWithoutAttributes.teamId) && Objects.equals(this.userId, analyticsParticipantWithoutAttributes.userId) && Objects.equals(this.sessions, analyticsParticipantWithoutAttributes.sessions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.externalContactId, this.externalOrganizationId, this.flaggedReason, this.participantId, this.participantName, this.purpose, this.teamId, this.userId, this.sessions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsParticipantWithoutAttributes {\n");
        sb.append("    externalContactId: ").append(this.toIndentedString(this.externalContactId)).append("\n");
        sb.append("    externalOrganizationId: ").append(this.toIndentedString(this.externalOrganizationId)).append("\n");
        sb.append("    flaggedReason: ").append(this.toIndentedString((Object)this.flaggedReason)).append("\n");
        sb.append("    participantId: ").append(this.toIndentedString(this.participantId)).append("\n");
        sb.append("    participantName: ").append(this.toIndentedString(this.participantName)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString((Object)this.purpose)).append("\n");
        sb.append("    teamId: ").append(this.toIndentedString(this.teamId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    sessions: ").append(this.toIndentedString(this.sessions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=PurposeEnumDeserializer.class)
    public static enum PurposeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACD("acd"),
        AGENT("agent"),
        API("api"),
        BOTFLOW("botflow"),
        CAMPAIGN("campaign"),
        CUSTOMER("customer"),
        DIALER("dialer"),
        EXTERNAL("external"),
        FAX("fax"),
        GROUP("group"),
        INBOUND("inbound"),
        IVR("ivr"),
        MANUAL("manual"),
        OUTBOUND("outbound"),
        STATION("station"),
        USER("user"),
        VOICEMAIL("voicemail"),
        WORKFLOW("workflow");

        private String value;

        private PurposeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PurposeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PurposeEnum value : PurposeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PurposeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PurposeEnumDeserializer
    extends StdDeserializer<PurposeEnum> {
        public PurposeEnumDeserializer() {
            super(PurposeEnumDeserializer.class);
        }

        public PurposeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PurposeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=FlaggedReasonEnumDeserializer.class)
    public static enum FlaggedReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GENERAL("general");

        private String value;

        private FlaggedReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FlaggedReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FlaggedReasonEnum value : FlaggedReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FlaggedReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FlaggedReasonEnumDeserializer
    extends StdDeserializer<FlaggedReasonEnum> {
        public FlaggedReasonEnumDeserializer() {
            super(FlaggedReasonEnumDeserializer.class);
        }

        public FlaggedReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FlaggedReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

