/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CategoryRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchKnowledgeKnowledgebaseCategoryRequest {
    private String knowledgeBaseId;
    private String categoryId;
    private CategoryRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public PatchKnowledgeKnowledgebaseCategoryRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public PatchKnowledgeKnowledgebaseCategoryRequest withCategoryId(String categoryId) {
        this.setCategoryId(categoryId);
        return this;
    }

    public CategoryRequest getBody() {
        return this.body;
    }

    public void setBody(CategoryRequest body) {
        this.body = body;
    }

    public PatchKnowledgeKnowledgebaseCategoryRequest withBody(CategoryRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchKnowledgeKnowledgebaseCategoryRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CategoryRequest> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseCategoryRequest.");
        }
        if (this.categoryId == null) {
            throw new IllegalStateException("Missing the required parameter 'categoryId' when building request for PatchKnowledgeKnowledgebaseCategoryRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseCategoryRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/categories/{categoryId}").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("categoryId", this.categoryId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String categoryId, CategoryRequest body) {
        return new Builder().withRequiredParams(knowledgeBaseId, categoryId, body);
    }

    public static class Builder {
        private final PatchKnowledgeKnowledgebaseCategoryRequest request = new PatchKnowledgeKnowledgebaseCategoryRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withCategoryId(String categoryId) {
            this.request.setCategoryId(categoryId);
            return this;
        }

        public Builder withBody(CategoryRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String categoryId, CategoryRequest body) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setCategoryId(categoryId);
            this.request.setBody(body);
            return this;
        }

        public PatchKnowledgeKnowledgebaseCategoryRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseCategoryRequest.");
            }
            if (this.request.categoryId == null) {
                throw new IllegalStateException("Missing the required parameter 'categoryId' when building request for PatchKnowledgeKnowledgebaseCategoryRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseCategoryRequest.");
            }
            return this.request;
        }
    }
}

