/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.UriReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the phone numbers, operating hours, and the Architect flows to execute for an IVR.")
public class IVR
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private Integer version = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String modifiedBy = null;
    private String createdBy = null;
    private StateEnum state = null;
    private String modifiedByApp = null;
    private String createdByApp = null;
    private List<String> dnis = new ArrayList<String>();
    private UriReference openHoursFlow = null;
    private UriReference closedHoursFlow = null;
    private UriReference scheduleGroup = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public IVR name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the entity.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IVR description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IVR version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public IVR dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public IVR dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public IVR modifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="modifiedBy")
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public IVR createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public IVR state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public IVR modifiedByApp(String modifiedByApp) {
        this.modifiedByApp = modifiedByApp;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="modifiedByApp")
    public String getModifiedByApp() {
        return this.modifiedByApp;
    }

    public void setModifiedByApp(String modifiedByApp) {
        this.modifiedByApp = modifiedByApp;
    }

    public IVR createdByApp(String createdByApp) {
        this.createdByApp = createdByApp;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="createdByApp")
    public String getCreatedByApp() {
        return this.createdByApp;
    }

    public void setCreatedByApp(String createdByApp) {
        this.createdByApp = createdByApp;
    }

    public IVR dnis(List<String> dnis) {
        this.dnis = dnis;
        return this;
    }

    @ApiModelProperty(example="null", value="The phone number(s) to contact the IVR by.  Each phone number must be unique and not in use by another resource.  For example, a user and an iVR cannot have the same phone number.")
    @JsonProperty(value="dnis")
    public List<String> getDnis() {
        return this.dnis;
    }

    public void setDnis(List<String> dnis) {
        this.dnis = dnis;
    }

    public IVR openHoursFlow(UriReference openHoursFlow) {
        this.openHoursFlow = openHoursFlow;
        return this;
    }

    @ApiModelProperty(example="null", value="The Architect flow to execute during the hours an organization is open.")
    @JsonProperty(value="openHoursFlow")
    public UriReference getOpenHoursFlow() {
        return this.openHoursFlow;
    }

    public void setOpenHoursFlow(UriReference openHoursFlow) {
        this.openHoursFlow = openHoursFlow;
    }

    public IVR closedHoursFlow(UriReference closedHoursFlow) {
        this.closedHoursFlow = closedHoursFlow;
        return this;
    }

    @ApiModelProperty(example="null", value="The Architect flow to execute during the hours an organization is closed.")
    @JsonProperty(value="closedHoursFlow")
    public UriReference getClosedHoursFlow() {
        return this.closedHoursFlow;
    }

    public void setClosedHoursFlow(UriReference closedHoursFlow) {
        this.closedHoursFlow = closedHoursFlow;
    }

    public IVR scheduleGroup(UriReference scheduleGroup) {
        this.scheduleGroup = scheduleGroup;
        return this;
    }

    @ApiModelProperty(example="null", value="The schedule group defining the open and closed hours for an organization.  If this is provided, an open flow and a closed flow must be specified as well.")
    @JsonProperty(value="scheduleGroup")
    public UriReference getScheduleGroup() {
        return this.scheduleGroup;
    }

    public void setScheduleGroup(UriReference scheduleGroup) {
        this.scheduleGroup = scheduleGroup;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IVR IVR2 = (IVR)o;
        return Objects.equals(this.id, IVR2.id) && Objects.equals(this.name, IVR2.name) && Objects.equals(this.description, IVR2.description) && Objects.equals(this.version, IVR2.version) && Objects.equals(this.dateCreated, IVR2.dateCreated) && Objects.equals(this.dateModified, IVR2.dateModified) && Objects.equals(this.modifiedBy, IVR2.modifiedBy) && Objects.equals(this.createdBy, IVR2.createdBy) && Objects.equals((Object)this.state, (Object)IVR2.state) && Objects.equals(this.modifiedByApp, IVR2.modifiedByApp) && Objects.equals(this.createdByApp, IVR2.createdByApp) && Objects.equals(this.dnis, IVR2.dnis) && Objects.equals(this.openHoursFlow, IVR2.openHoursFlow) && Objects.equals(this.closedHoursFlow, IVR2.closedHoursFlow) && Objects.equals(this.scheduleGroup, IVR2.scheduleGroup) && Objects.equals(this.selfUri, IVR2.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.version, this.dateCreated, this.dateModified, this.modifiedBy, this.createdBy, this.state, this.modifiedByApp, this.createdByApp, this.dnis, this.openHoursFlow, this.closedHoursFlow, this.scheduleGroup, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IVR {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    modifiedByApp: ").append(this.toIndentedString(this.modifiedByApp)).append("\n");
        sb.append("    createdByApp: ").append(this.toIndentedString(this.createdByApp)).append("\n");
        sb.append("    dnis: ").append(this.toIndentedString(this.dnis)).append("\n");
        sb.append("    openHoursFlow: ").append(this.toIndentedString(this.openHoursFlow)).append("\n");
        sb.append("    closedHoursFlow: ").append(this.toIndentedString(this.closedHoursFlow)).append("\n");
        sb.append("    scheduleGroup: ").append(this.toIndentedString(this.scheduleGroup)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

