/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.ContactListFilterRange;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class ContactListFilterPredicate
implements Serializable {
    private String column = null;
    private ColumnTypeEnum columnType = null;
    private OperatorEnum operator = null;
    private String value = null;
    private ContactListFilterRange range = null;
    private Boolean inverted = null;

    public ContactListFilterPredicate column(String column) {
        this.column = column;
        return this;
    }

    @ApiModelProperty(example="null", value="Contact List column that must match a contact list column in the ContactListFilter's contactList object")
    @JsonProperty(value="column")
    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public ContactListFilterPredicate columnType(ColumnTypeEnum columnType) {
        this.columnType = columnType;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the contact column contains numeric or alphabetic data")
    @JsonProperty(value="columnType")
    public ColumnTypeEnum getColumnType() {
        return this.columnType;
    }

    public void setColumnType(ColumnTypeEnum columnType) {
        this.columnType = columnType;
    }

    public ContactListFilterPredicate operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public ContactListFilterPredicate value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="Contact List value to operate on. This could be text, a number, or a relative time. A value for relative time should follow the format PxxDTyyHzzM, where xx, yy, and zz specify the days, hours and minutes. For example, a value of P01DT08H30M corresponds to 1 day, 8 hours, and 30 minutes from now. To specify a time in the past, include a negative sign before each numeric value. For example, a value of P-01DT-08H-30M corresponds to 1 day, 8 hours, and 30 minutes in the past. You can also do things like P01DT00H-30M, which would correspond to 23 hours and 30 minutes from now (1 day - 30 minutes).")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ContactListFilterPredicate range(ContactListFilterRange range) {
        this.range = range;
        return this;
    }

    @ApiModelProperty(example="null", value="Range is only required for ContactListFilterComparisonOperator's BETWEEN and IN")
    @JsonProperty(value="range")
    public ContactListFilterRange getRange() {
        return this.range;
    }

    public void setRange(ContactListFilterRange range) {
        this.range = range;
    }

    public ContactListFilterPredicate inverted(Boolean inverted) {
        this.inverted = inverted;
        return this;
    }

    @ApiModelProperty(example="null", value="Inverts the result of the predicate (i.e., if the predicate returns true, inverting it will return false).")
    @JsonProperty(value="inverted")
    public Boolean getInverted() {
        return this.inverted;
    }

    public void setInverted(Boolean inverted) {
        this.inverted = inverted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactListFilterPredicate contactListFilterPredicate = (ContactListFilterPredicate)o;
        return Objects.equals(this.column, contactListFilterPredicate.column) && Objects.equals((Object)this.columnType, (Object)contactListFilterPredicate.columnType) && Objects.equals((Object)this.operator, (Object)contactListFilterPredicate.operator) && Objects.equals(this.value, contactListFilterPredicate.value) && Objects.equals(this.range, contactListFilterPredicate.range) && Objects.equals(this.inverted, contactListFilterPredicate.inverted);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.columnType, this.operator, this.value, this.range, this.inverted});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactListFilterPredicate {\n");
        sb.append("    column: ").append(this.toIndentedString(this.column)).append("\n");
        sb.append("    columnType: ").append(this.toIndentedString((Object)this.columnType)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    range: ").append(this.toIndentedString(this.range)).append("\n");
        sb.append("    inverted: ").append(this.toIndentedString(this.inverted)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EQUALS("EQUALS"),
        LESS_THAN("LESS_THAN"),
        LESS_THAN_EQUALS("LESS_THAN_EQUALS"),
        GREATER_THAN("GREATER_THAN"),
        GREATER_THAN_EQUALS("GREATER_THAN_EQUALS"),
        CONTAINS("CONTAINS"),
        BEGINS_WITH("BEGINS_WITH"),
        ENDS_WITH("ENDS_WITH"),
        BEFORE("BEFORE"),
        AFTER("AFTER"),
        BETWEEN("BETWEEN"),
        IN("IN");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ColumnTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NUMERIC("numeric"),
        ALPHABETIC("alphabetic");

        private String value;

        private ColumnTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ColumnTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ColumnTypeEnum value : ColumnTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ColumnTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

