/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PutAuthorizationRoleUsersAddRequest {
    private String roleId;
    private List<String> body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public PutAuthorizationRoleUsersAddRequest withRoleId(String roleId) {
        this.setRoleId(roleId);
        return this;
    }

    public List<String> getBody() {
        return this.body;
    }

    public void setBody(List<String> body) {
        this.body = body;
    }

    public PutAuthorizationRoleUsersAddRequest withBody(List<String> body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutAuthorizationRoleUsersAddRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<List<String>> withHttpInfo() {
        if (this.roleId == null) {
            throw new IllegalStateException("Missing the required parameter 'roleId' when building request for PutAuthorizationRoleUsersAddRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutAuthorizationRoleUsersAddRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/authorization/roles/{roleId}/users/add").withPathParameter("roleId", this.roleId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String roleId, List<String> body) {
        return new Builder().withRequiredParams(roleId, body);
    }

    public static class Builder {
        private final PutAuthorizationRoleUsersAddRequest request = new PutAuthorizationRoleUsersAddRequest();

        private Builder() {
        }

        public Builder withRoleId(String roleId) {
            this.request.setRoleId(roleId);
            return this;
        }

        public Builder withBody(List<String> body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String roleId, List<String> body) {
            this.request.setRoleId(roleId);
            this.request.setBody(body);
            return this;
        }

        public PutAuthorizationRoleUsersAddRequest build() {
            if (this.request.roleId == null) {
                throw new IllegalStateException("Missing the required parameter 'roleId' when building request for PutAuthorizationRoleUsersAddRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutAuthorizationRoleUsersAddRequest.");
            }
            return this.request;
        }
    }
}

