/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetUserPresenceRequest {
    private String userId;
    private String sourceId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public GetUserPresenceRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public GetUserPresenceRequest withSourceId(String sourceId) {
        this.setSourceId(sourceId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetUserPresenceRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetUserPresenceRequest.");
        }
        if (this.sourceId == null) {
            throw new IllegalStateException("Missing the required parameter 'sourceId' when building request for GetUserPresenceRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/users/{userId}/presences/{sourceId}").withPathParameter("userId", this.userId).withPathParameter("sourceId", this.sourceId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, String sourceId) {
        return new Builder().withRequiredParams(userId, sourceId);
    }

    public static class Builder {
        private final GetUserPresenceRequest request = new GetUserPresenceRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withSourceId(String sourceId) {
            this.request.setSourceId(sourceId);
            return this;
        }

        public Builder withRequiredParams(String userId, String sourceId) {
            this.request.setUserId(userId);
            this.request.setSourceId(sourceId);
            return this;
        }

        public GetUserPresenceRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetUserPresenceRequest.");
            }
            if (this.request.sourceId == null) {
                throw new IllegalStateException("Missing the required parameter 'sourceId' when building request for GetUserPresenceRequest.");
            }
            return this.request;
        }
    }
}

