/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class ExternalMetricDefinition
implements Serializable {
    private String id = null;
    private String name = null;
    private UnitEnum unit = null;
    private String unitDefinition = null;
    private Integer precision = null;
    private DefaultObjectiveTypeEnum defaultObjectiveType = null;
    private Integer retentionMonths = null;
    private Boolean enabled = null;
    private Boolean inUse = null;
    private Date dateLastRefreshed = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ExternalMetricDefinition name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the External Metric Definition")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExternalMetricDefinition unit(UnitEnum unit) {
        this.unit = unit;
        return this;
    }

    @ApiModelProperty(example="null", value="The unit of the External Metric Definition")
    @JsonProperty(value="unit")
    public UnitEnum getUnit() {
        return this.unit;
    }

    public void setUnit(UnitEnum unit) {
        this.unit = unit;
    }

    public ExternalMetricDefinition unitDefinition(String unitDefinition) {
        this.unitDefinition = unitDefinition;
        return this;
    }

    @ApiModelProperty(example="null", value="The unit definition of the External Metric Definition")
    @JsonProperty(value="unitDefinition")
    public String getUnitDefinition() {
        return this.unitDefinition;
    }

    public void setUnitDefinition(String unitDefinition) {
        this.unitDefinition = unitDefinition;
    }

    public ExternalMetricDefinition precision(Integer precision) {
        this.precision = precision;
        return this;
    }

    @ApiModelProperty(example="null", value="The decimal precision of the External Metric Definition")
    @JsonProperty(value="precision")
    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public ExternalMetricDefinition defaultObjectiveType(DefaultObjectiveTypeEnum defaultObjectiveType) {
        this.defaultObjectiveType = defaultObjectiveType;
        return this;
    }

    @ApiModelProperty(example="null", value="The default objective type of the External Metric Definition")
    @JsonProperty(value="defaultObjectiveType")
    public DefaultObjectiveTypeEnum getDefaultObjectiveType() {
        return this.defaultObjectiveType;
    }

    public void setDefaultObjectiveType(DefaultObjectiveTypeEnum defaultObjectiveType) {
        this.defaultObjectiveType = defaultObjectiveType;
    }

    public ExternalMetricDefinition retentionMonths(Integer retentionMonths) {
        this.retentionMonths = retentionMonths;
        return this;
    }

    @ApiModelProperty(example="null", value="The retention in months of the External Metric Definition")
    @JsonProperty(value="retentionMonths")
    public Integer getRetentionMonths() {
        return this.retentionMonths;
    }

    public void setRetentionMonths(Integer retentionMonths) {
        this.retentionMonths = retentionMonths;
    }

    public ExternalMetricDefinition enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="True if the External Metric Definition is enabled")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @ApiModelProperty(example="null", value="True if the External Metric Definition is in use")
    @JsonProperty(value="inUse")
    public Boolean getInUse() {
        return this.inUse;
    }

    public ExternalMetricDefinition dateLastRefreshed(Date dateLastRefreshed) {
        this.dateLastRefreshed = dateLastRefreshed;
        return this;
    }

    @ApiModelProperty(example="null", value="The last date and time that the metric data was refreshed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateLastRefreshed")
    public Date getDateLastRefreshed() {
        return this.dateLastRefreshed;
    }

    public void setDateLastRefreshed(Date dateLastRefreshed) {
        this.dateLastRefreshed = dateLastRefreshed;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalMetricDefinition externalMetricDefinition = (ExternalMetricDefinition)o;
        return Objects.equals(this.id, externalMetricDefinition.id) && Objects.equals(this.name, externalMetricDefinition.name) && Objects.equals((Object)this.unit, (Object)externalMetricDefinition.unit) && Objects.equals(this.unitDefinition, externalMetricDefinition.unitDefinition) && Objects.equals(this.precision, externalMetricDefinition.precision) && Objects.equals((Object)this.defaultObjectiveType, (Object)externalMetricDefinition.defaultObjectiveType) && Objects.equals(this.retentionMonths, externalMetricDefinition.retentionMonths) && Objects.equals(this.enabled, externalMetricDefinition.enabled) && Objects.equals(this.inUse, externalMetricDefinition.inUse) && Objects.equals(this.dateLastRefreshed, externalMetricDefinition.dateLastRefreshed) && Objects.equals(this.selfUri, externalMetricDefinition.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.unit, this.unitDefinition, this.precision, this.defaultObjectiveType, this.retentionMonths, this.enabled, this.inUse, this.dateLastRefreshed, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalMetricDefinition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString((Object)this.unit)).append("\n");
        sb.append("    unitDefinition: ").append(this.toIndentedString(this.unitDefinition)).append("\n");
        sb.append("    precision: ").append(this.toIndentedString(this.precision)).append("\n");
        sb.append("    defaultObjectiveType: ").append(this.toIndentedString((Object)this.defaultObjectiveType)).append("\n");
        sb.append("    retentionMonths: ").append(this.toIndentedString(this.retentionMonths)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    inUse: ").append(this.toIndentedString(this.inUse)).append("\n");
        sb.append("    dateLastRefreshed: ").append(this.toIndentedString(this.dateLastRefreshed)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DefaultObjectiveTypeEnumDeserializer.class)
    public static enum DefaultObjectiveTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HIGHERISBETTER("HigherIsBetter"),
        LOWERISBETTER("LowerIsBetter"),
        TARGETAREA("TargetArea");

        private String value;

        private DefaultObjectiveTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DefaultObjectiveTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DefaultObjectiveTypeEnum value : DefaultObjectiveTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DefaultObjectiveTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DefaultObjectiveTypeEnumDeserializer
    extends StdDeserializer<DefaultObjectiveTypeEnum> {
        public DefaultObjectiveTypeEnumDeserializer() {
            super(DefaultObjectiveTypeEnumDeserializer.class);
        }

        public DefaultObjectiveTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DefaultObjectiveTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=UnitEnumDeserializer.class)
    public static enum UnitEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SECONDS("Seconds"),
        PERCENT("Percent"),
        NUMBER("Number"),
        CURRENCY("Currency");

        private String value;

        private UnitEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UnitEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UnitEnum value : UnitEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UnitEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UnitEnumDeserializer
    extends StdDeserializer<UnitEnum> {
        public UnitEnumDeserializer() {
            super(UnitEnumDeserializer.class);
        }

        public UnitEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UnitEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

