/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class DeleteCoachingAppointmentAnnotationRequest {
    private String appointmentId;
    private String annotationId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAppointmentId() {
        return this.appointmentId;
    }

    public void setAppointmentId(String appointmentId) {
        this.appointmentId = appointmentId;
    }

    public DeleteCoachingAppointmentAnnotationRequest withAppointmentId(String appointmentId) {
        this.setAppointmentId(appointmentId);
        return this;
    }

    public String getAnnotationId() {
        return this.annotationId;
    }

    public void setAnnotationId(String annotationId) {
        this.annotationId = annotationId;
    }

    public DeleteCoachingAppointmentAnnotationRequest withAnnotationId(String annotationId) {
        this.setAnnotationId(annotationId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteCoachingAppointmentAnnotationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.appointmentId == null) {
            throw new IllegalStateException("Missing the required parameter 'appointmentId' when building request for DeleteCoachingAppointmentAnnotationRequest.");
        }
        if (this.annotationId == null) {
            throw new IllegalStateException("Missing the required parameter 'annotationId' when building request for DeleteCoachingAppointmentAnnotationRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/coaching/appointments/{appointmentId}/annotations/{annotationId}").withPathParameter("appointmentId", this.appointmentId).withPathParameter("annotationId", this.annotationId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String appointmentId, String annotationId) {
        return new Builder().withRequiredParams(appointmentId, annotationId);
    }

    public static class Builder {
        private final DeleteCoachingAppointmentAnnotationRequest request = new DeleteCoachingAppointmentAnnotationRequest();

        private Builder() {
        }

        public Builder withAppointmentId(String appointmentId) {
            this.request.setAppointmentId(appointmentId);
            return this;
        }

        public Builder withAnnotationId(String annotationId) {
            this.request.setAnnotationId(annotationId);
            return this;
        }

        public Builder withRequiredParams(String appointmentId, String annotationId) {
            this.request.setAppointmentId(appointmentId);
            this.request.setAnnotationId(annotationId);
            return this;
        }

        public DeleteCoachingAppointmentAnnotationRequest build() {
            if (this.request.appointmentId == null) {
                throw new IllegalStateException("Missing the required parameter 'appointmentId' when building request for DeleteCoachingAppointmentAnnotationRequest.");
            }
            if (this.request.annotationId == null) {
                throw new IllegalStateException("Missing the required parameter 'annotationId' when building request for DeleteCoachingAppointmentAnnotationRequest.");
            }
            return this.request;
        }
    }
}

