/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.NamedEntity;
import com.mypurecloud.sdk.v2.model.SubscriptionOverviewUsage;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class TrusteeBillingOverview
implements Serializable {
    private String id = null;
    private String name = null;
    private NamedEntity organization = null;
    private String currency = null;
    private List<String> enabledProducts = new ArrayList<String>();
    private SubscriptionTypeEnum subscriptionType = null;
    private Date rampPeriodStartDate = null;
    private Date rampPeriodEndDate = null;
    private Date billingPeriodStartDate = null;
    private Date billingPeriodEndDate = null;
    private List<SubscriptionOverviewUsage> usages = new ArrayList<SubscriptionOverviewUsage>();
    private Date contractAmendmentDate = null;
    private Date contractEffectiveDate = null;
    private Date contractEndDate = null;
    private String minimumMonthlyAmount = null;
    private Boolean inRampPeriod = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public TrusteeBillingOverview name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TrusteeBillingOverview organization(NamedEntity organization) {
        this.organization = organization;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Organization")
    @JsonProperty(value="organization")
    public NamedEntity getOrganization() {
        return this.organization;
    }

    public void setOrganization(NamedEntity organization) {
        this.organization = organization;
    }

    public TrusteeBillingOverview currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The currency type.")
    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public TrusteeBillingOverview enabledProducts(List<String> enabledProducts) {
        this.enabledProducts = enabledProducts;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The charge short names for products enabled during the specified period.")
    @JsonProperty(value="enabledProducts")
    public List<String> getEnabledProducts() {
        return this.enabledProducts;
    }

    public void setEnabledProducts(List<String> enabledProducts) {
        this.enabledProducts = enabledProducts;
    }

    public TrusteeBillingOverview subscriptionType(SubscriptionTypeEnum subscriptionType) {
        this.subscriptionType = subscriptionType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The subscription type.")
    @JsonProperty(value="subscriptionType")
    public SubscriptionTypeEnum getSubscriptionType() {
        return this.subscriptionType;
    }

    public void setSubscriptionType(SubscriptionTypeEnum subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public TrusteeBillingOverview rampPeriodStartDate(Date rampPeriodStartDate) {
        this.rampPeriodStartDate = rampPeriodStartDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date-time the ramp period starts. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="rampPeriodStartDate")
    public Date getRampPeriodStartDate() {
        return this.rampPeriodStartDate;
    }

    public void setRampPeriodStartDate(Date rampPeriodStartDate) {
        this.rampPeriodStartDate = rampPeriodStartDate;
    }

    public TrusteeBillingOverview rampPeriodEndDate(Date rampPeriodEndDate) {
        this.rampPeriodEndDate = rampPeriodEndDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date-time the ramp period ends. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="rampPeriodEndDate")
    public Date getRampPeriodEndDate() {
        return this.rampPeriodEndDate;
    }

    public void setRampPeriodEndDate(Date rampPeriodEndDate) {
        this.rampPeriodEndDate = rampPeriodEndDate;
    }

    public TrusteeBillingOverview billingPeriodStartDate(Date billingPeriodStartDate) {
        this.billingPeriodStartDate = billingPeriodStartDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date-time the billing period started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="billingPeriodStartDate")
    public Date getBillingPeriodStartDate() {
        return this.billingPeriodStartDate;
    }

    public void setBillingPeriodStartDate(Date billingPeriodStartDate) {
        this.billingPeriodStartDate = billingPeriodStartDate;
    }

    public TrusteeBillingOverview billingPeriodEndDate(Date billingPeriodEndDate) {
        this.billingPeriodEndDate = billingPeriodEndDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date-time the billing period ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="billingPeriodEndDate")
    public Date getBillingPeriodEndDate() {
        return this.billingPeriodEndDate;
    }

    public void setBillingPeriodEndDate(Date billingPeriodEndDate) {
        this.billingPeriodEndDate = billingPeriodEndDate;
    }

    public TrusteeBillingOverview usages(List<SubscriptionOverviewUsage> usages) {
        this.usages = usages;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Usages for the specified period.")
    @JsonProperty(value="usages")
    public List<SubscriptionOverviewUsage> getUsages() {
        return this.usages;
    }

    public void setUsages(List<SubscriptionOverviewUsage> usages) {
        this.usages = usages;
    }

    public TrusteeBillingOverview contractAmendmentDate(Date contractAmendmentDate) {
        this.contractAmendmentDate = contractAmendmentDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date-time the contract was last amended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="contractAmendmentDate")
    public Date getContractAmendmentDate() {
        return this.contractAmendmentDate;
    }

    public void setContractAmendmentDate(Date contractAmendmentDate) {
        this.contractAmendmentDate = contractAmendmentDate;
    }

    public TrusteeBillingOverview contractEffectiveDate(Date contractEffectiveDate) {
        this.contractEffectiveDate = contractEffectiveDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date-time the contract became effective. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="contractEffectiveDate")
    public Date getContractEffectiveDate() {
        return this.contractEffectiveDate;
    }

    public void setContractEffectiveDate(Date contractEffectiveDate) {
        this.contractEffectiveDate = contractEffectiveDate;
    }

    public TrusteeBillingOverview contractEndDate(Date contractEndDate) {
        this.contractEndDate = contractEndDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date-time the contract ends. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="contractEndDate")
    public Date getContractEndDate() {
        return this.contractEndDate;
    }

    public void setContractEndDate(Date contractEndDate) {
        this.contractEndDate = contractEndDate;
    }

    public TrusteeBillingOverview minimumMonthlyAmount(String minimumMonthlyAmount) {
        this.minimumMonthlyAmount = minimumMonthlyAmount;
        return this;
    }

    @ApiModelProperty(example="null", value="Minimum amount that will be charged for the month")
    @JsonProperty(value="minimumMonthlyAmount")
    public String getMinimumMonthlyAmount() {
        return this.minimumMonthlyAmount;
    }

    public void setMinimumMonthlyAmount(String minimumMonthlyAmount) {
        this.minimumMonthlyAmount = minimumMonthlyAmount;
    }

    public TrusteeBillingOverview inRampPeriod(Boolean inRampPeriod) {
        this.inRampPeriod = inRampPeriod;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="inRampPeriod")
    public Boolean getInRampPeriod() {
        return this.inRampPeriod;
    }

    public void setInRampPeriod(Boolean inRampPeriod) {
        this.inRampPeriod = inRampPeriod;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrusteeBillingOverview trusteeBillingOverview = (TrusteeBillingOverview)o;
        return Objects.equals(this.id, trusteeBillingOverview.id) && Objects.equals(this.name, trusteeBillingOverview.name) && Objects.equals(this.organization, trusteeBillingOverview.organization) && Objects.equals(this.currency, trusteeBillingOverview.currency) && Objects.equals(this.enabledProducts, trusteeBillingOverview.enabledProducts) && Objects.equals((Object)this.subscriptionType, (Object)trusteeBillingOverview.subscriptionType) && Objects.equals(this.rampPeriodStartDate, trusteeBillingOverview.rampPeriodStartDate) && Objects.equals(this.rampPeriodEndDate, trusteeBillingOverview.rampPeriodEndDate) && Objects.equals(this.billingPeriodStartDate, trusteeBillingOverview.billingPeriodStartDate) && Objects.equals(this.billingPeriodEndDate, trusteeBillingOverview.billingPeriodEndDate) && Objects.equals(this.usages, trusteeBillingOverview.usages) && Objects.equals(this.contractAmendmentDate, trusteeBillingOverview.contractAmendmentDate) && Objects.equals(this.contractEffectiveDate, trusteeBillingOverview.contractEffectiveDate) && Objects.equals(this.contractEndDate, trusteeBillingOverview.contractEndDate) && Objects.equals(this.minimumMonthlyAmount, trusteeBillingOverview.minimumMonthlyAmount) && Objects.equals(this.inRampPeriod, trusteeBillingOverview.inRampPeriod) && Objects.equals(this.selfUri, trusteeBillingOverview.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.organization, this.currency, this.enabledProducts, this.subscriptionType, this.rampPeriodStartDate, this.rampPeriodEndDate, this.billingPeriodStartDate, this.billingPeriodEndDate, this.usages, this.contractAmendmentDate, this.contractEffectiveDate, this.contractEndDate, this.minimumMonthlyAmount, this.inRampPeriod, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrusteeBillingOverview {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    enabledProducts: ").append(this.toIndentedString(this.enabledProducts)).append("\n");
        sb.append("    subscriptionType: ").append(this.toIndentedString((Object)this.subscriptionType)).append("\n");
        sb.append("    rampPeriodStartDate: ").append(this.toIndentedString(this.rampPeriodStartDate)).append("\n");
        sb.append("    rampPeriodEndDate: ").append(this.toIndentedString(this.rampPeriodEndDate)).append("\n");
        sb.append("    billingPeriodStartDate: ").append(this.toIndentedString(this.billingPeriodStartDate)).append("\n");
        sb.append("    billingPeriodEndDate: ").append(this.toIndentedString(this.billingPeriodEndDate)).append("\n");
        sb.append("    usages: ").append(this.toIndentedString(this.usages)).append("\n");
        sb.append("    contractAmendmentDate: ").append(this.toIndentedString(this.contractAmendmentDate)).append("\n");
        sb.append("    contractEffectiveDate: ").append(this.toIndentedString(this.contractEffectiveDate)).append("\n");
        sb.append("    contractEndDate: ").append(this.toIndentedString(this.contractEndDate)).append("\n");
        sb.append("    minimumMonthlyAmount: ").append(this.toIndentedString(this.minimumMonthlyAmount)).append("\n");
        sb.append("    inRampPeriod: ").append(this.toIndentedString(this.inRampPeriod)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SubscriptionTypeEnumDeserializer.class)
    public static enum SubscriptionTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ININ("ININ"),
        MONTH_TO_MONTH("MONTH_TO_MONTH"),
        FREE_TRIAL_MONTH_TO_MONTH("FREE_TRIAL_MONTH_TO_MONTH"),
        PREPAY_MONTHLY_COMMITMENT("PREPAY_MONTHLY_COMMITMENT"),
        PREPAY("PREPAY"),
        DEV_ORG_MONTH_TO_MONTH("DEV_ORG_MONTH_TO_MONTH"),
        DEV_ORG_PREPAY_MONTHLY_COMMITMENT("DEV_ORG_PREPAY_MONTHLY_COMMITMENT"),
        DEV_ORG_PREPAY("DEV_ORG_PREPAY");

        private String value;

        private SubscriptionTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SubscriptionTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SubscriptionTypeEnum value : SubscriptionTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SubscriptionTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SubscriptionTypeEnumDeserializer
    extends StdDeserializer<SubscriptionTypeEnum> {
        public SubscriptionTypeEnumDeserializer() {
            super(SubscriptionTypeEnumDeserializer.class);
        }

        public SubscriptionTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SubscriptionTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

