/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ContactPhoneNumberColumn;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.ImportStatus;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ContactList
implements Serializable {
    private String id = null;
    private String name = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Integer version = null;
    private DomainEntityRef division = null;
    private List<String> columnNames = new ArrayList<String>();
    private List<ContactPhoneNumberColumn> phoneColumns = new ArrayList<ContactPhoneNumberColumn>();
    private ImportStatus importStatus = null;
    private String previewModeColumnName = null;
    private List<String> previewModeAcceptedValues = new ArrayList<String>();
    private Long size = null;
    private DomainEntityRef attemptLimits = null;
    private Boolean automaticTimeZoneMapping = null;
    private String zipCodeColumnName = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ContactList name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public ContactList version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Required for updates, must match the version number of the most recent update")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public ContactList division(DomainEntityRef division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division this entity belongs to.")
    @JsonProperty(value="division")
    public DomainEntityRef getDivision() {
        return this.division;
    }

    public void setDivision(DomainEntityRef division) {
        this.division = division;
    }

    public ContactList columnNames(List<String> columnNames) {
        this.columnNames = columnNames;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The names of the contact data columns.")
    @JsonProperty(value="columnNames")
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public ContactList phoneColumns(List<ContactPhoneNumberColumn> phoneColumns) {
        this.phoneColumns = phoneColumns;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates which columns are phone numbers.")
    @JsonProperty(value="phoneColumns")
    public List<ContactPhoneNumberColumn> getPhoneColumns() {
        return this.phoneColumns;
    }

    public void setPhoneColumns(List<ContactPhoneNumberColumn> phoneColumns) {
        this.phoneColumns = phoneColumns;
    }

    public ContactList importStatus(ImportStatus importStatus) {
        this.importStatus = importStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the import process.")
    @JsonProperty(value="importStatus")
    public ImportStatus getImportStatus() {
        return this.importStatus;
    }

    public void setImportStatus(ImportStatus importStatus) {
        this.importStatus = importStatus;
    }

    public ContactList previewModeColumnName(String previewModeColumnName) {
        this.previewModeColumnName = previewModeColumnName;
        return this;
    }

    @ApiModelProperty(example="null", value="A column to check if a contact should always be dialed in preview mode.")
    @JsonProperty(value="previewModeColumnName")
    public String getPreviewModeColumnName() {
        return this.previewModeColumnName;
    }

    public void setPreviewModeColumnName(String previewModeColumnName) {
        this.previewModeColumnName = previewModeColumnName;
    }

    public ContactList previewModeAcceptedValues(List<String> previewModeAcceptedValues) {
        this.previewModeAcceptedValues = previewModeAcceptedValues;
        return this;
    }

    @ApiModelProperty(example="null", value="The values in the previewModeColumnName column that indicate a contact should always be dialed in preview mode.")
    @JsonProperty(value="previewModeAcceptedValues")
    public List<String> getPreviewModeAcceptedValues() {
        return this.previewModeAcceptedValues;
    }

    public void setPreviewModeAcceptedValues(List<String> previewModeAcceptedValues) {
        this.previewModeAcceptedValues = previewModeAcceptedValues;
    }

    @ApiModelProperty(example="null", value="The number of contacts in the ContactList.")
    @JsonProperty(value="size")
    public Long getSize() {
        return this.size;
    }

    public ContactList attemptLimits(DomainEntityRef attemptLimits) {
        this.attemptLimits = attemptLimits;
        return this;
    }

    @ApiModelProperty(example="null", value="AttemptLimits for this ContactList.")
    @JsonProperty(value="attemptLimits")
    public DomainEntityRef getAttemptLimits() {
        return this.attemptLimits;
    }

    public void setAttemptLimits(DomainEntityRef attemptLimits) {
        this.attemptLimits = attemptLimits;
    }

    public ContactList automaticTimeZoneMapping(Boolean automaticTimeZoneMapping) {
        this.automaticTimeZoneMapping = automaticTimeZoneMapping;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if automatic time zone mapping is to be used for this ContactList.")
    @JsonProperty(value="automaticTimeZoneMapping")
    public Boolean getAutomaticTimeZoneMapping() {
        return this.automaticTimeZoneMapping;
    }

    public void setAutomaticTimeZoneMapping(Boolean automaticTimeZoneMapping) {
        this.automaticTimeZoneMapping = automaticTimeZoneMapping;
    }

    public ContactList zipCodeColumnName(String zipCodeColumnName) {
        this.zipCodeColumnName = zipCodeColumnName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of contact list column containing the zip code for use with automatic time zone mapping. Only allowed if 'automaticTimeZoneMapping' is set to true.")
    @JsonProperty(value="zipCodeColumnName")
    public String getZipCodeColumnName() {
        return this.zipCodeColumnName;
    }

    public void setZipCodeColumnName(String zipCodeColumnName) {
        this.zipCodeColumnName = zipCodeColumnName;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactList contactList = (ContactList)o;
        return Objects.equals(this.id, contactList.id) && Objects.equals(this.name, contactList.name) && Objects.equals(this.dateCreated, contactList.dateCreated) && Objects.equals(this.dateModified, contactList.dateModified) && Objects.equals(this.version, contactList.version) && Objects.equals(this.division, contactList.division) && Objects.equals(this.columnNames, contactList.columnNames) && Objects.equals(this.phoneColumns, contactList.phoneColumns) && Objects.equals(this.importStatus, contactList.importStatus) && Objects.equals(this.previewModeColumnName, contactList.previewModeColumnName) && Objects.equals(this.previewModeAcceptedValues, contactList.previewModeAcceptedValues) && Objects.equals(this.size, contactList.size) && Objects.equals(this.attemptLimits, contactList.attemptLimits) && Objects.equals(this.automaticTimeZoneMapping, contactList.automaticTimeZoneMapping) && Objects.equals(this.zipCodeColumnName, contactList.zipCodeColumnName) && Objects.equals(this.selfUri, contactList.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.dateCreated, this.dateModified, this.version, this.division, this.columnNames, this.phoneColumns, this.importStatus, this.previewModeColumnName, this.previewModeAcceptedValues, this.size, this.attemptLimits, this.automaticTimeZoneMapping, this.zipCodeColumnName, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactList {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    columnNames: ").append(this.toIndentedString(this.columnNames)).append("\n");
        sb.append("    phoneColumns: ").append(this.toIndentedString(this.phoneColumns)).append("\n");
        sb.append("    importStatus: ").append(this.toIndentedString(this.importStatus)).append("\n");
        sb.append("    previewModeColumnName: ").append(this.toIndentedString(this.previewModeColumnName)).append("\n");
        sb.append("    previewModeAcceptedValues: ").append(this.toIndentedString(this.previewModeAcceptedValues)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    attemptLimits: ").append(this.toIndentedString(this.attemptLimits)).append("\n");
        sb.append("    automaticTimeZoneMapping: ").append(this.toIndentedString(this.automaticTimeZoneMapping)).append("\n");
        sb.append("    zipCodeColumnName: ").append(this.toIndentedString(this.zipCodeColumnName)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

