/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Variance in minutes among start times of shifts in work plan")
public class ShiftStartVariance
implements Serializable {
    private List<ApplicableDaysEnum> applicableDays = new ArrayList<ApplicableDaysEnum>();
    private Integer maxShiftStartVarianceMinutes = null;

    public ShiftStartVariance applicableDays(List<ApplicableDaysEnum> applicableDays) {
        this.applicableDays = applicableDays;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Days for which shift start variance is configured")
    @JsonProperty(value="applicableDays")
    public List<ApplicableDaysEnum> getApplicableDays() {
        return this.applicableDays;
    }

    public void setApplicableDays(List<ApplicableDaysEnum> applicableDays) {
        this.applicableDays = applicableDays;
    }

    public ShiftStartVariance maxShiftStartVarianceMinutes(Integer maxShiftStartVarianceMinutes) {
        this.maxShiftStartVarianceMinutes = maxShiftStartVarianceMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Maximum variance in minutes across shift starts")
    @JsonProperty(value="maxShiftStartVarianceMinutes")
    public Integer getMaxShiftStartVarianceMinutes() {
        return this.maxShiftStartVarianceMinutes;
    }

    public void setMaxShiftStartVarianceMinutes(Integer maxShiftStartVarianceMinutes) {
        this.maxShiftStartVarianceMinutes = maxShiftStartVarianceMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftStartVariance shiftStartVariance = (ShiftStartVariance)o;
        return Objects.equals(this.applicableDays, shiftStartVariance.applicableDays) && Objects.equals(this.maxShiftStartVarianceMinutes, shiftStartVariance.maxShiftStartVarianceMinutes);
    }

    public int hashCode() {
        return Objects.hash(this.applicableDays, this.maxShiftStartVarianceMinutes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShiftStartVariance {\n");
        sb.append("    applicableDays: ").append(this.toIndentedString(this.applicableDays)).append("\n");
        sb.append("    maxShiftStartVarianceMinutes: ").append(this.toIndentedString(this.maxShiftStartVarianceMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ApplicableDaysEnumDeserializer.class)
    public static enum ApplicableDaysEnum {
        SUNDAY("Sunday"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday");

        private String value;

        private ApplicableDaysEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ApplicableDaysEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ApplicableDaysEnum value : ApplicableDaysEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ApplicableDaysEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ApplicableDaysEnumDeserializer
    extends StdDeserializer<ApplicableDaysEnum> {
        public ApplicableDaysEnumDeserializer() {
            super(ApplicableDaysEnumDeserializer.class);
        }

        public ApplicableDaysEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ApplicableDaysEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

